PS_debugmode = true;
PS_ZoneNames = {};
PS_remove = 0;
PS_addpop = 0;
PS_width = 0;
PS_mocheck = 0;
PS_sendmsg = "";
PS_TFF = 0;
PS_LZI = "";
PS_neww = 0;
PS_tpos = 1;
PS_cchck = nil;
PS_cchck2 = nil;
PS_thelist = "";
PS_Redraw = false;
PS_HitNum = 0;
PS_faction = UnitFactionGroup("player");
PS_MyLevel = UnitLevel("player");
PS_starttime = GetTime() - 3;
PS_ClickTime = GetTime() - 2;
PS_timer = GetTime() - 1;
PS_lastpinged = "";
PS_lasttip = nil;
PS_bgmode = false;
PS_skipchk = 0;
PS_CombatMode = "";
PS_stealth = false;
PS_DeathTime = nil;
PS_DeathName = "";
PS_Ffix = 110;
PS_Split = "";
PS_Echeck = 0;
PS_Enemy = 0;
PS_dim = 0;
PS_CSG = 0;
PS_MMT = 0;
PS_X = 0;
PS_Y = 0;
PS_PS = "Personal Sentry v1.60b";

function PS_OnLoad()

  this:RegisterEvent("PLAYER_ENTERING_WORLD");
  this:RegisterEvent("VARIABLES_LOADED");
  this:RegisterEvent("PLAYER_TARGET_CHANGED");
  this:RegisterEvent("UPDATE_BATTLEFIELD_SCORE");
  this:RegisterEvent("UPDATE_MOUSEOVER_UNIT");
  this:RegisterEvent("SPELLCAST_CHANNEL_START");
  this:RegisterEvent("WHO_LIST_UPDATE");
  this:RegisterEvent("CHAT_MSG_SYSTEM");
  this:RegisterEvent("ZONE_CHANGED_NEW_AREA");
  this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
  this:RegisterEvent("CHAT_MSG_COMBAT_HONOR_GAIN");
  this:RegisterEvent("PLAYER_REGEN_DISABLED");
  this:RegisterEvent("PLAYER_REGEN_ENABLED");
  lOriginal_Minimap_OnClick_Event = Minimap_OnClick;
  Minimap_OnClick = PS_Minimap_OnClick_Event;
  lOriginal_FriendsFrame_OnEvent = FriendsFrame_OnEvent;
  FriendsFrame_OnEvent = PS_FriendsFrame_OnEvent;
  SlashCmdList["PS"] = function(msg)
    PS_Slash(msg);
  end
  SLASH_PS1 = "/PS";
  SLASH_PS2 = "/personalsentry";
end

function PS_FriendsFrame_OnEvent()

  if (event == "WHO_LIST_UPDATE" and PS_TFF == 1) then
    return;
  else
    lOriginal_FriendsFrame_OnEvent();
  end
end

function PS_ToggleLock()

  PSvars.Locked = not PSvars.Locked;
  PS_UpdateLock();
end

function PS_UpdateLock()

  local classicon = getglobal("PS_PopupButton1"..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon");
  if PSvars.Locked then
    classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\Images\\locked");
  else
    classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\Images\\unlocked");
  end
  getglobal("PS_Popup"..PS_CombatMode..PS_Split..PSvars.PopupMode):Show();
end

function PS_ToggleMinimapButton()

  if PSvars.MiniIcon == 0 then
    PS_TraceFrame(PS_HIDDEN);
  end
  PS_Minimap_RefreshMinimap();
  PS_Minimap_RefreshMinimap2();
end

function PS_TraceFrame(text)

  DEFAULT_CHAT_FRAME:AddMessage(PS_WARNING..text, 1, .25, .3)
end

function PS_ShowCustom(note)

  local Class = PS_UnitClass("player");
  local Level = PS_MyLevel;
  local Race = PS_UnitRace("player");
  local Name = UnitName("player");
  if note == "warning" then
    local Loc = GetMinimapZoneText();
    local x, y = GetPlayerMapPosition("player");
    x = math.floor(x*100);
    y = math.floor(y*100);
    local xy = x..", "..y;
    PS_sendmsg = PSvars.CustomWarning;
    PS_sendmsg = string.gsub(PS_sendmsg, '%%w', PS_DF..PS_PLAYER);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%n', Name);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%c', Class);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%l', Level);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%r', Race);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%x', xy);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%z', Loc);
  else
    PS_sendmsg = "|"..PSvars.CustomPopup;
    PS_sendmsg = string.gsub(PS_sendmsg, '%%n', Name);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%c', Class);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%l', Level);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%r', Race);
    PS_sendmsg = PS_sendmsg.." |";
    if string.find(PS_sendmsg, "nohealth") then
      PS_sendmsg = string.gsub(PS_sendmsg, ' nohealth', "");
      PS_sendmsg = string.gsub(PS_sendmsg, 'nohealth ', "");
      PS_sendmsg = string.gsub(PS_sendmsg, 'nohealth', "");
      PS_sendmsg = PS_sendmsg.." [No healthbar]";
    end
  end
  DEFAULT_CHAT_FRAME:AddMessage(PS_CUSTOM, .3, 1, .75);
  DEFAULT_CHAT_FRAME:AddMessage(PS_sendmsg, .3, 1, .75);
  PS_sendmsg = "";
end

function PS_GetFoundString(name, data)

  local found = name.." ("..data.Level;
  if data.Race ~= nil then
    found = found.." "..data.Race;
  end
  found = found.." "..data.Class..")";
  if data.Zone ~= nil and data.Zone ~= "" then
    found = found..". Last seen at "..data.Zone;
  end
  if data.SubZone ~= nil and data.SubZone ~= "" then
    found = found.."/"..data.SubZone;
  end
  return found;
end

function PS_SearchTarget(target)

  local counter = 0;
  local found = "";
  DEFAULT_CHAT_FRAME:AddMessage( "Searching: "..target, 1, 1, 1);
  for name, data in pairs(PSvars.Database) do
    if string.find(string.lower(name), target) then
      found = PS_GetFoundString(name, data);
      counter = counter + 1;
      DEFAULT_CHAT_FRAME:AddMessage(counter..": "..found, 1, 0, 0);
    end
  end
  DEFAULT_CHAT_FRAME:AddMessage("Found: "..counter.." entries.", 1, 1, 1);
end

function PS_Slash(msg)

  local lmsg = string.lower(msg);
  if string.find(lmsg, "options") then
    PS_OptionsForm_InitializeOptions();
    PS_OptionsForm:Show();
  elseif string.find(lmsg, "search") then
    for target in string.gmatch(lmsg, "search (%a+)") do
      PS_SearchTarget(target);
    end
  elseif string.find(lmsg, "debug") then
    PS_debugmode = not PS_debugmode;
    if PS_debugmode then
      DEFAULT_CHAT_FRAME:AddMessage("PS Debug : ON.", 1, 1, 0);
    else
      DEFAULT_CHAT_FRAME:AddMessage("PS Debug : OFF.", 1, 1, 0);
    end
  elseif (string.sub(lmsg,1,10) == "maxtargets") then
    if (string.len(lmsg) > 10) then
      local number = string.sub(msg,11);
      if tonumber(number) ~= nil then
        if (tonumber(number) > 0 and tonumber(number) < 41) then
          PSvars.MaxTargets = tonumber(number) + 1;
          DEFAULT_CHAT_FRAME:AddMessage("PS: Max popup targets is now set to "..number.."!",1,1,0);
        else
          DEFAULT_CHAT_FRAME:AddMessage("PS: Invalid number of targets! Please set from 1 to 40.",1,1,.5);
        end
      else
        DEFAULT_CHAT_FRAME:AddMessage("PS: Invalid number of targets! Please set from 1 to 40.",1,1,.5);
      end
    end
  elseif (string.sub(lmsg,1,7) == "warnmsg") then
    if (string.len(lmsg) > 8) then
      PSvars.CustomWarning = string.sub(msg,9);
      if string.lower(PSvars.CustomWarning) == "reset" then
        PSvars.CustomWarning = "";
        PS_TraceFrame(PS_CWR);
      else
        PS_ShowCustom("warning");
      end
    else
      PS_Slash("/ps custom");
    end
  elseif (string.sub(lmsg,1,8) == "popupmsg") then
    if (string.len(lmsg) > 9) then
      PSvars.CustomPopup = string.sub(msg,10);
      if string.lower(PSvars.CustomPopup) == "reset" then
        PSvars.CustomPopup = "";
        PS_TraceFrame(PS_CPR);
      else
        PS_ShowCustom("popup");
      end
      for i=2, PSvars.MaxTargets do
        getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode.."Button"):SetText("");
        getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode):SetAlpha(0);
        getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode):Hide();
      end
    else
      PS_Slash("/ps custom");
    end
    PS_Clear_Popup();
    PS_dim = 1;
    PS_addpop = 0;
    PS_Process_Tooltip(PS_thelist);
  elseif string.find(lmsg, "custom") then
    DEFAULT_CHAT_FRAME:AddMessage("Custom Popup and Announcement Functions", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("---------------------------------------------------", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("%l - Displays the LEVEL of the target.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("%n - Displays the NAME of the target.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("%c - Displays the CLASS of the target.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("%r - Displays the RACE of the target.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("nohealth - Disables the health display of targets on the popup.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage(" ", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("Custom Announcement Functions ONLY", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("---------------------------------------------", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("%w - Adds 'Detecting/WARNING Friendy/Enemy Player/NPC' to your announcement.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("%z - Displays the zone or sub-zone where you saw the target.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("%x - Displays the numeric map location of the target in format x, y.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage(" ", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("Use '/ps popupmsg' or '/ps warnmsg' to create custom displays.", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("Example:", .4, 1, .4);
    DEFAULT_CHAT_FRAME:AddMessage("/ps popupmsg [%l %c] %n -%r- nohealth", .6, .6, 1);
    DEFAULT_CHAT_FRAME:AddMessage("will display on the popup as:", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("[61 Druid] Filche -Tauren- (no colored healthbar [transparent])", .6, .6, 1);
    DEFAULT_CHAT_FRAME:AddMessage("Example2:", .4, 1, .4);
    DEFAULT_CHAT_FRAME:AddMessage("/ps warnmsg %w %n wants his level %l %c butt kicked near %z <%x>", 1, .6, .6);
    DEFAULT_CHAT_FRAME:AddMessage("will announce this message:", 1, 1, 1);
    DEFAULT_CHAT_FRAME:AddMessage("-WARNING!- Enemy Player Filche wants his level 61 Tauren butt kicked near Thrallmar <56, 37>", 1, .6, .6);
    if (PSvars.CustomPopup ~= "" or PSvars.CustomWarning ~= "") then
      DEFAULT_CHAT_FRAME:AddMessage(" ", 1, 1, 1);
      if PSvars.CustomPopup ~= "" then
        DEFAULT_CHAT_FRAME:AddMessage("Current custom popup message: "..PSvars.CustomPopup);
      end
      if PSvars.CustomWarning ~= "" then
        DEFAULT_CHAT_FRAME:AddMessage("Current custom announcement: "..PSvars.CustomWarning);
      end
    end
  elseif string.find(lmsg, "hitlist") then
    if (string.len(lmsg) > 8) then
      for data in string.gmatch(lmsg, "hitlist (%a+)") do
        if string.len(data) > 16 then
          return;
        elseif data == "clear" then
          for name, data in pairs(PSvars.Database) do
            if data.IsKOS then
              if data.Race == "Unknown" then
                PSvars.Database[name] = nil;
              else
                data.IsKOS = false;
                PSvars.Database[name] = data;
              end
            end
          end
          DEFAULT_CHAT_FRAME:AddMessage(PS_PLA..PS_RHL, 0, 1, 0);
          if PSvars.SentrySound then
            PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitremove.wav");
          end
          return;
        end
        local beg = string.sub(data, 1, 1);
        local hind = string.sub(data, 2);
        beg = string.upper(beg);
        data = beg..hind;
        targetData = PSvars.Database[data];
        if targetData ~= nil then
          local level = targetData.Level;
          if (targetData.IsGuess or targetData.TooHigh) then
            level = level.."+";
          end
          if targetData.IsPlayer and targetData.IsEnemy then
            if not targetData.IsKOS then
              targetData.IsKOS = true;
              if targetData.DayNum == nil then
                targetData.DayNum = date("%j");
              end
              PSvars.Database[data] = targetData;
              DEFAULT_CHAT_FRAME:AddMessage(data.." ["..targetData.Level.." "..targetData.Race.." "..targetData.Class.."]: "..PS_AHL, 1, .3, .6);
              if PSvars.SentrySound then
                PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitadd.wav");
              end
              if PS_HitList:IsVisible() then
               PS_New_Hitlist(true);
              end
            else
              targetData.IsKOS = false;
              if targetData.Race == "Unknown" then
                PSvars.Database[data] = nil;
              else
                PSvars.Database[data] = targetData;
              end
              DEFAULT_CHAT_FRAME:AddMessage(data.." ["..level.." "..targetData.Race.." "..targetData.Class.."]: "..PS_RHL, .3, 1, .6);
              if PSvars.SentrySound then
                PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitremove.wav");
              end
              if PS_HitList:IsVisible() then
                PS_New_Hitlist(true);
              end
            end
          end
        else
          targetData = PS_GetEmptyTargetEntry();
          targetData.IsKOS = true;
          targetData.IsPlayer = true;
          targetData.IsEnemy = true;
          targetData.IsGuess = true;
          targetData.Level = PS_MyLevel;
          targetData.Race = "Unknown";
          targetData.Class = PS_WARRIOR;
          targetData.DayNum = date("%j");
          PSvars.Database[data] = targetData;
          DEFAULT_CHAT_FRAME:AddMessage(data.." [Manually added]:"..PS_AHL, 1, .3, .6);
          if PSvars.SentrySound then
            PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitadd.wav");
          end
          if PS_HitList:IsVisible() then
            PS_New_Hitlist(true);
          end
        end
      end
    else
      PS_New_Hitlist(false);
    end
  else
    DEFAULT_CHAT_FRAME:AddMessage(PS_PS..PS_VERSION,1,.1,1);
    DEFAULT_CHAT_FRAME:AddMessage(" ",1 ,1 ,0);
    DEFAULT_CHAT_FRAME:AddMessage("Popup functions list:",1,1,1);
    DEFAULT_CHAT_FRAME:AddMessage("=====================",1,1,1);
    DEFAULT_CHAT_FRAME:AddMessage("Left-click - Targets the unit if not in combat.",1,1,.25);
    DEFAULT_CHAT_FRAME:AddMessage("Right-click - Targets AND announces the unit.",1,1,.25);
    DEFAULT_CHAT_FRAME:AddMessage("Shift right-click - Forces an announcement, even if you can't target the unit.",1,1,.25);
    DEFAULT_CHAT_FRAME:AddMessage("Control right-click - Forces a ping on the minimap with the announcement.",1,1,.25);
    DEFAULT_CHAT_FRAME:AddMessage("Shift left-click (on players) - Toggles an enemy player on your 'Hit List'.",1,1,.25);
    DEFAULT_CHAT_FRAME:AddMessage("Shift left-click (on pets) - Targets the owner of the pet (if known).",1,1,.25);
    DEFAULT_CHAT_FRAME:AddMessage("Middle-click {or Alt left-click} - Removes a target from the popup (until you logoff).",1,1,.25);
    DEFAULT_CHAT_FRAME:AddMessage(" ",1 ,1 ,0);
    DEFAULT_CHAT_FRAME:AddMessage("Command line functions:",1,1,1);
    DEFAULT_CHAT_FRAME:AddMessage("=======================",1,1,1);
    DEFAULT_CHAT_FRAME:AddMessage("/PS options - Displays GUI menu to modify addon settings.",1,1,.5);
    DEFAULT_CHAT_FRAME:AddMessage("/PS search (target name) - Searches through target database.",1,1,.5);
    DEFAULT_CHAT_FRAME:AddMessage("/PS custom - Lists custom message functions and examples.",1,1,.5);
    DEFAULT_CHAT_FRAME:AddMessage("/PS popupmsg (text) - Sets a custom popup display.",1,1,.5);
    DEFAULT_CHAT_FRAME:AddMessage("/PS warnmsg (text) - Sets a custom announcement.",1,1,.5);
    DEFAULT_CHAT_FRAME:AddMessage("/PS hitlist - Displays your current enemy player 'Hit List'.",1,1.5);
    DEFAULT_CHAT_FRAME:AddMessage("/PS hitlist (target name) - Toggles the target name to your 'Hit List'.",1,1,.5);
    DEFAULT_CHAT_FRAME:AddMessage("/PS maxtargets ## - Sets the number of max popup targets (where ## is from 1 to 40).",1,1,.5);
  end
end

function PS_HitListClick()

  local data = this.data;
  local line = this.line;
  local lineoffset = this.lineoffset;
  local targetData = PSvars.Database[data];
  if targetData ~= nil then
    local level = targetData.Level;
    if (targetData.IsGuess or targetData.TooHigh) then
      level = level.."+";
    end
    if targetData.IsKOS then
      getglobal("HitListEntry"..line):SetText("      *  *  * "..data.." "..PS_REMOVED.."  *  *  *");
      getglobal("HitListEntry"..line):Show();
      targetData.IsKOS = false;
      if targetData.Race == "Unknown" then
        PSvars.Database[data] = nil;
      else
        PSvars.Database[data] = targetData;
      end
      DEFAULT_CHAT_FRAME:AddMessage(data.." ["..level.." "..targetData.Race.." "..targetData.Class.."]: "..PS_RHL, .3, 1, .6);
      if PSvars.SentrySound then
        PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitremove.wav");
      end
    else
      PS_HitList_Update();
      targetData.IsKOS = true;
      if targetData.DayNum == nil then
        targetData.DayNum = date("%j");
      end
      PSvars.Database[data] = targetData;
      DEFAULT_CHAT_FRAME:AddMessage(data.." ["..targetData.Level.." "..targetData.Race.." "..targetData.Class.."]: "..PS_AHL, 1, .3, .6);
      if PSvars.SentrySound then
        PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitadd.wav");
      end
    end
  else
    PS_HitList_Update();
    targetData = PS_GetEmptyTargetEntry();
    targetData.IsKOS = true;
    targetData.IsPlayer = true;
    targetData.IsEnemy = true;
    targetData.IsGuess = true;
    targetData.Level = PS_MyLevel;
    targetData.Race = "Unknown";
    targetData.Class = PS_WARRIOR;
    targetData.DayNum = date("%j");
    PSvars.Database[data] = targetData;
    DEFAULT_CHAT_FRAME:AddMessage(data.." [Manually added]:"..PS_AHL, 1, .3, .6);
    if PSvars.SentrySound then
      PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitadd.wav");
    end
  end
end

function PS_HitList_Update()

  local line, lineplusoffset;
  FauxScrollFrame_Update(PS_HitList_ScrollBar,PS_HitNum,5,16);
  for line=1,10 do
    lineplusoffset = line + FauxScrollFrame_GetOffset(PS_HitList_ScrollBar);
    if HitListData[lineplusoffset] ~= nil then
      getglobal("HitListEntry"..line):SetText(HitListData[lineplusoffset]);
      getglobal("HitListEntry"..line):Show();
      local button = getglobal("HitListEntry"..line);
      button.data = PSvars.HLData[lineplusoffset];
      button.line = line;
      button.lineoffset = lineplusoffset;
    else
      getglobal("HitListEntry"..line):Hide();
    end
  end
end

function PS_New_Hitlist(check)

  if (PS_HitList:IsVisible() and not check) then
    PS_HitList:Hide();
    return;
  elseif check then
    PS_HitList:Hide();
  end
  HitListData = {}
  PSvars.Sort = {}
  PSvars.HLData = {}
  local counter = 1;
  local lastseen;
  for name, targetData in pairs(PSvars.Database) do
    if targetData.IsKOS then
      if targetData.DayNum == nil then
        targetData.DayNum = date("%j");
        lastseen = date("%j");
        PSvars.Database[name] = targetData;
      else
        lastseen = targetData.DayNum;
      end
      if date("%j") - lastseen < 0 then
        lastseen = 365 - lastseen + date("%j");
      else
        lastseen = date("%j") - lastseen;
      end
      PSvars.Sort[counter] = lastseen;
      counter = counter + 1;
    end
  end
  table.sort(PSvars.Sort, function(a,b) return a<b end);
  local counter = 0;
  FoundHL = {}
  for count, data in pairs(PSvars.Sort) do
    for name, targetData in pairs(PSvars.Database) do
      if targetData.IsKOS then
        if date("%j") - targetData.DayNum < 0 then
          lastseen = 365 - targetData.DayNum + date("%j");
        else
          lastseen = date("%j") - targetData.DayNum;
        end
        if lastseen == data then
          if FoundHL[name] == nil then
            counter = counter + 1;
            FoundHL[name] = count;
            local shown = PS_ColorizeTooltipText(name, true);
            if (GetLocale() == "enUS" or GetLocale() == "enGB") then
              if lastseen == 0 then
                lastseen = " * "..PS_TODAY.." *    - ";
              elseif lastseen == 1 then
                lastseen = " 1 day ago    - ";
              elseif lastseen < 10 then
                lastseen = " "..lastseen.." days ago  - ";
              else
                lastseen = lastseen.." days ago - ";
              end
            elseif (GetLocale() == "frFR") then
              if lastseen == 0 then
                lastseen = " * "..PS_TODAY.." *  - ";
              elseif lastseen == 1 then
                lastseen = " 1 jour     - ";
              elseif lastseen < 10 then
                lastseen = " "..lastseen.." jours   - ";
              else
                lastseen = lastseen.." jours  - ";
              end
            else
              if lastseen == 0 then
                lastseen = " * "..PS_TODAY.." * - ";
              elseif lastseen == 1 then
                lastseen = " vor einem Tag - ";
              elseif lastseen < 10 then
                lastseen = " vor "..lastseen.." Tagen - ";
              else
                lastseen = " vor "..lastseen.." Tagen - ";
              end
            end
            HitListData[counter] = lastseen..shown;
            PSvars.HLData[counter] = name;
            break;
          end
        end
      end
    end
  end
  PS_HitNum = counter;
  PS_HitList:Show();
  PS_HitList_ScrollBar:Show();
end

function PS_OnEvent(event, eventdata)

  local zonetext = GetRealZoneText();
  if (PS_ZoneIsABG(zonetext) or IsActiveBattlefieldArena()) then
    PS_TFF = 0;
    PS_bgmode = true;
  elseif (event == "ZONE_CHANGED_NEW_AREA") then
    if zonetext ~= PS_LZI then
      if (PSvars.Addons ~= "OFF" and PSvars.Addons ~= "BG") then
        PS_TFF = 1;
        local zwho = "z-"..zonetext.." 1-70";
        SendWho(zwho);
        PS_LZI = zonetext;
        PS_timer = GetTime() + 1;
      end
      PS_bgmode = false;
      return;
    end
  else
    PS_bgmode = false;
  end
  PS_SentryCheck = true;
  if (event == "VARIABLES_LOADED") then
    PS_LoadSavedVariables();
    PS_OptionsForm:Hide();
    PS_OptionsForm_InitializeOptions();
    if DEFAULT_CHAT_FRAME then
      DEFAULT_CHAT_FRAME:AddMessage(PS_PS..PS_VERSION);
      if PSvars.SentryMode then
        DEFAULT_CHAT_FRAME:AddMessage(PS_SENTRYON);
      else
        DEFAULT_CHAT_FRAME:AddMessage(PS_SENTRYOFF);
      end
    end
    PS_UpdateLock();
    if not PSvars.KeepBG then
      PS_PurgeTempEntries();
    end
    PS_PurgePetEntries();
    if PSvars.MiniIcon == 0 then
      PS_TraceFrame(PS_HIDDEN);
    end
    if PSvars.Addons == "OFF" then
      PS_TraceFrame(PS_DISABLED);
    end
    PS_Clear_Popup();
    PS_thelist = "";
    PSvars.list = {};
    PS_PurgePetEntries();
    PS_Enemy = 0;
    return;
  end
  if (event == "PLAYER_ENTERING_WORLD") then
    if PSvars.ClearEnter then
      PS_Clear_Popup();
      PS_thelist = "";
      PSvars.list = {};
      PS_PurgePetEntries();
      PS_Enemy = 0;
    end
    SetMapToCurrentZone();
    PS_ZoneNames = {GetMapZones(GetCurrentMapContinent())}
    return;
  end
  if (PS_SentryCheck == false or PSvars.Addons == "OFF" or (PSvars.Addons == "BG" and not PS_bgmode and not IsActiveBattlefieldArena()) or (PSvars.Addons == "NOBG" and (PS_bgmode or IsActiveBattlefieldArena())) or (PSvars.Addons == "NOT BG" and PS_bgmode) or (PSvars.Addons == "NOT ARENA" and IsActiveBattlefieldArena())) then
    if PS_tpos > 0 then
      PS_Clear_Popup();
      PS_thelist = "";
      PSvars.list = {};
      PS_Enemy = 0;
    end
    return;
  end
  if (PSvars.Addons ~= "OFF" and PSvars.SentryChk) then
    local subzone = GetZoneText();
    PS_SentryCheck = true;
    for i = 1, table.getn(PS_NeutralZones) do
      if subzone == PS_NeutralZones[i] then
        PS_SentryCheck = false;
      end
    end
  else
    PS_SentryCheck = true;
  end
  if event == "PLAYER_REGEN_DISABLED" then
    PS_Clear_Popup();
    PS_CombatMode = "Com";
    PS_Frame:ClearAllPoints();
    PS_PopupComUPWARD:ClearAllPoints();
    PS_PopupComSplitUPWARD:ClearAllPoints();
    if PS_Split == "Split" then
      if PSvars.scale == .55 then
        PS_Ffix = 59;
      elseif PSvars.scale == .7 then
        PS_Ffix = 77;
      elseif PSvars.scale == .85 then
        PS_Ffix = 94;
      else
        PS_Ffix = 110;
      end
      PS_Frame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.DownL - PS_Ffix, PSvars.DownT);
    else
      PS_Frame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.DownL, PSvars.DownT);
    end
    PS_PopupComUPWARD:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.UpL, PSvars.UpT);
    PS_PopupComSplitUPWARD:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.UpL, PSvars.UpT);
    PS_dim = 1;
    PS_addpop = 0;
    PS_Process_Tooltip(PS_thelist);
    return;
  end
  if event == "PLAYER_REGEN_ENABLED" then
    PS_Clear_Popup();
    PS_CombatMode = "";
    PS_Frame:ClearAllPoints();
    PS_PopupUPWARD:ClearAllPoints();
    PS_PopupSplitUPWARD:ClearAllPoints();
    if PS_Split == "Split" then
      if PSvars.scale == .55 then
        PS_Ffix = 59;
      elseif PSvars.scale == .7 then
        PS_Ffix = 77;
      elseif PSvars.scale == .85 then
        PS_Ffix = 94;
      else
        PS_Ffix = 110;
      end
      PS_Frame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.DownL - PS_Ffix, PSvars.DownT);
    else
      PS_Frame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.DownL, PSvars.DownT);
    end
    PS_PopupUPWARD:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.UpL, PSvars.UpT);
    PS_PopupSplitUPWARD:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.UpL, PSvars.UpT);
    PS_dim = 1;
    PS_addpop = 0;
    PS_Process_Tooltip(PS_thelist);
    return;
  end
  if (event == "UPDATE_MOUSEOVER_UNIT") then
    local listData = PS_GetListData(UnitName("mouseover"));
    local targetData = PS_GetUnitData(UnitName("mouseover"));
    if (listData.pos > 1 and ((UnitName("mouseover") == PS_SHADOWFIEND or UnitCreatureType("mouseover") == PS_BEAST or UnitCreatureType("mouseover") == PS_ELEMENTAL or UnitCreatureType("mouseover") == PS_DEMON) or ((UnitClassification("mouseover") ~= "normal" and UnitClassification("mouseover") ~= targetData.Notes) or (targetData.Isplayer and not UnitIsPlayer("mouseover")) or (targetData.Isplayer == false and UnitIsPlayer("mouseover"))))) then
      if (UnitName("mouseover") == PS_SHADOWFIEND or (UnitCreatureType("mouseover") == PS_BEAST and not UnitIsPlayer("mouseover")) or UnitCreatureType("mouseover") == PS_ELEMENTAL or UnitCreatureType("mouseover") == PS_DEMON) then
        if (targetData.IsPet == true or not listData.known) then
          PS_GrabPet(UnitName("mouseover"), UnitIsEnemy("mouseover", "player"), "mouseover");
          PS_Refresh(UnitName("mouseover"), UnitIsPlayer("mouseover"), UnitIsEnemy("mouseover", "player"), "mouseover", UnitLevel("mouseover"), PS_UnitRace("mouseover"), PS_UnitClass("mouseover"), listData.pos);
        end
        PS_CaptureAttack(UnitName("mouseover"), "YOU", nil, "mouseover", 1);
      end
    elseif (listData.pos > 1 and (not listData.known or targetData.Race == "Unknown" or targetData.IsGuess or UnitLevel("mouseover") ~= targetData.Level or (UnitIsPlayer("mouseover") and not UnitIsPVP("mouseover") and targetData.Notes ~= "PvP2"))) then
      PS_CaptureAttack(UnitName("mouseover"), "YOU", nil, "mouseover", 1);
    elseif (listData.pos == 0 and PSvars.SentryMode and PS_SentryCheck) then
      if (UnitName("mouseover") ~= nil and UnitCreatureType("mouseover") ~= PS_CRITTER and not UnitIsDeadOrGhost("mouseover")) then
        if (not UnitIsPlayer("mouseover") and UnitLevel("mouseover") ~= 1) then
          PS_GrabPet(UnitName("mouseover"), UnitIsEnemy("mouseover", "player"), "mouseover");
          if not targetData.IsPlayer then
            PS_CaptureAttack(UnitName("mouseover"), "YOU", nil, "mouseover", 1);
          end
        elseif (UnitIsPlayer("mouseover") and UnitIsPVP("mouseover")) then
          PS_CaptureAttack(UnitName("mouseover"), "YOU", nil, "mouseover", 1);
        elseif (UnitIsPlayer("mouseover") and IsShiftKeyDown()) then
          PS_CaptureAttack(UnitName("mouseover"), "YOU", nil, "mouseover", 2);
        end
      end
    elseif (listData.pos > 1 and UnitIsPVP("mouseover")) then
      PS_AutoNotify(UnitName("mouseover"), targetData.Class, targetData.Race, targetData.Level, nil, targetData.IsKOS, true);
    end
    return;
  end
  if (event == "PLAYER_TARGET_CHANGED") then
    if UnitName("target") ~= nil then
      local unitname = UnitName("target");
      local listData = PS_GetListData(unitname);
      if PS_cchck2 == unitname then
        PS_remove = 0;
      end
      local targetData = PS_GetUnitData(unitname);
      local level = UnitLevel("target");
      local class = PS_UnitClass("target");
      local isenemy = UnitIsEnemy("target", "player");
      local isplayer = UnitIsPlayer("target");
      local iselite = UnitClassification("target");
      local race = PS_UnitRace("target");
      local faction = UnitFactionGroup("target");
      local ispvp = UnitIsPVP("target");
      local ispet = UnitCreatureType("target");
      targetData.Zone = GetRealZoneText();
      targetData.SubZone = GetSubZoneText();
      targetData.Class = class;
      targetData.Race = race;
--      if not targetData.IsGuess then
--        targetData.Level = level;
--      end
--      if level == -1 then
--        if (isplayer and PS_MyLevel > 59) then
--          targetData.Level = 70;
--          targetData.IsGuess = false;
--        else
--          targetData.TooHigh = PS_MyLevel;
--          targetData.Level = PS_MyLevel + 10;
--        end
--      end
--      if isplayer then
--        if IsActiveBattlefieldArena() then
--          targetData.IsTemp = true;
--        else
--          targetData.IsTemp = PS_bgmode;
--        end
--      end
--      targetData.IsPlayer = isplayer;
--      targetData.IsEnemy = isenemy;
--      if ispvp then
--        targetData.Notes = "PvP";
--      end
--      if iselite == "elite" or iselite == "rare" or iselite == "rareelite" then
--        targetData.Notes = iselite;
--      end
--      if ((PSvars.storage == "PLAYERS" and not isplayer) or (PSvars.storage == "NPC" and isplayer) or PSvars.storage == "NONE") then
--        targetData.IsTemp = true;
--      end
--      PSvars.Database[unitname] = targetData;
      if listData.pos > 1 then
        if not isplayer then
          PS_GrabPet(unitname, isenemy, "target");
        end
        if not targetData.IsPlayer then
          PS_CaptureAttack(unitname, "YOU", nil, "target", 1);
        end
      elseif (listData.pos == 0 and PSvars.SentryMode and PS_SentryCheck) then
        if (unitname ~= nil and ispet ~= PS_CRITTER and not UnitIsDeadOrGhost("target")) then
          if (not isplayer and level ~= 1) then
            PS_GrabPet(unitname, isenemy, "target");
            PS_CaptureAttack(unitname, "YOU", nil, "target", 1);
          elseif ((isplayer and ispvp) or (isplayer and IsShiftKeyDown())) then
            PS_CaptureAttack(unitname, "YOU", nil, "target", 1);
          end
        end
      elseif (listData.pos > 1 and UnitIsPVP("target")) then
        PS_AutoNotify(unitname, targetData.Class, targetData.Race, targetData.Level, nil, targetData.IsKOS, true);
      end
      listData = PS_GetListData(unitname);
      if (listData.pos > 1 and PS_cchck == unitname) then
        local srace, sclass, setag, setmess;
        if isenemy then
          setag = PS_WE;
        else
          setag = PS_DF;
        end
        if isplayer then
          setmess = PS_PLAYER;
          srace = " "..race;
          sclass =" "..class;
        else
          setmess = PS_NPLAYER;
          srace = "";
          sclass = "";
        end
        if level == -1 then
          level = tostring(PS_MyLevel + 10).."+";
        end
        local Loc = GetMinimapZoneText();
        local x, y = GetPlayerMapPosition("player");
        x = math.floor(x*100);
        y = math.floor(y*100);
        local xy = x..", "..y;
        if PSvars.CustomWarning == "" then
          PS_sendmsg = setag..setmess..unitname.." ("..level..srace..sclass..")"..PS_NEARBY..Loc.." ["..xy.."]";
        else
          PS_sendmsg = PSvars.CustomWarning;
          if not isplayer then
            PS_sendmsg = string.gsub(PS_sendmsg, ' %%c', "");
            PS_sendmsg = string.gsub(PS_sendmsg, ' %%r', "");
          end
          PS_sendmsg = string.gsub(PS_sendmsg, '%%w', setag..setmess);
          PS_sendmsg = string.gsub(PS_sendmsg, '%%n', unitname);
          PS_sendmsg = string.gsub(PS_sendmsg, ' %%c', sclass);
          PS_sendmsg = string.gsub(PS_sendmsg, '%%l', level);
          PS_sendmsg = string.gsub(PS_sendmsg, ' %%r', srace);
          PS_sendmsg = string.gsub(PS_sendmsg, '%%x', xy);
          PS_sendmsg = string.gsub(PS_sendmsg, '%%z', Loc);
        end
      elseif (listData.pos == 0 and PS_cchck == unitname) then
        PS_sendmsg = "";
      end
    end
    return;
  end
  if (event == "CHAT_MSG_SYSTEM") then
    for name in string.gmatch(arg1, PS_DIES2) do
      PS_DeathDetect(name);
      return;
    end
  end
  if (event == "CHAT_MSG_COMBAT_HONOR_GAIN") then
    for name in string.gmatch(arg1, PS_HONOR) do
      PS_DeathDetect(name);
      return;
    end
  end
  if (event == "UPDATE_BATTLEFIELD_SCORE") then
    if PS_MyLevel < UnitLevel("player") then
      PS_MyLevel = UnitLevel("player");
    end
    if (PS_bgmode or IsActiveBattlefieldArena()) then
      PS_GetBGData();
    end
  end
  if (event == "WHO_LIST_UPDATE") then
    if PS_MyLevel < UnitLevel("player") then
      PS_MyLevel = UnitLevel("player");
    end
    local numWhos, totalCount = GetNumWhoResults();
    if totalCount > 0 then
      for numwho = 1, totalCount do
        local charname, guildname, level, race, class, zone, unknown = GetWhoInfo(numwho);
        race = PS_UnitRaceFix(race);
        class = PS_UnitClassFix(class);
        if charname ~= UnitName("player") then
          local whoData = PSvars.Database[charname];
          if whoData == nil then
            whoData = PS_GetUnitData(charname);
            whoData.IsTemp = true;
          end
          whoData.Level = level;
          whoData.Class = class;
          whoData.Race = race;
          whoData.Zone = zone;
          whoData.IsPlayer = true;
          whoData.IsEnemy = false;
          PSvars.Database[charname] = whoData;
        end
      end
    end
    PS_TFF = 0;
    return;
  end

end

function PS_GetBGData()

  local pass = false;
  for i=1, GetNumBattlefieldScores() do
    local name, killingBlows, honorableKills, deaths, honorGained, faction, rank, race, class = GetBattlefieldScore(i);
    race = PS_UnitRaceFix(race);
    class = PS_UnitClassFix(class);
    if string.find(name, "-") ~= nil then
      _, _, name = string.find(name, "(.*)-(.*)")
    end
    targetData = PSvars.Database[name];
    if targetData == nil then
      pass = true;
    elseif targetData.Level < PS_DetermineBGLevel(PS_MyLevel) then
      pass = true;
    end
    if pass then
      targetData = PS_GetEmptyTargetEntry();
      targetData.IsPlayer = true;
      targetData.Class = class;
      targetData.Race = race;
      targetData.Level = PS_DetermineBGLevel(PS_MyLevel);
      targetData.IsGuess = true;
      targetData.IsTemp = true;
      if(targetData.Zone == "") then
        targetData.Zone = GetRealZoneText();
        targetData.SubZone = GetSubZoneText();
      end
      if ((PS_faction == "Horde" and faction == 0) or (PS_faction == "Alliance" and faction == 1)) then
        targetData.IsEnemy = false;
      else
        targetData.IsEnemy = true;
      end
      PSvars.Database[name] = targetData;
    end
  end
end

function PS_RemoveTarget(rcheck)

  local listData = PSvars.list[rcheck];
  local targetData = PSvars.Database[rcheck];
  if listData == nil then
    return;
  end
  local encount = 1;
  if (listData.known and PS_remove == 3) then
    PS_remove = 0;
    return;
  end
  if (not listData.known or PS_remove ~= 0) then
    if PS_remove == 2 then
      local targetData = PS_GetUnitData(rcheck);
      if targetData ~= nil then
        if (targetData.Class == PS_HUNTER or targetData.Class == PS_MAGE or targetData.Class == PS_WARLOCK) then
          for name, data in pairs(PSvars.Database) do
            if data.IsPet ~= nil then
              if data.IsPet ~= true and data.IsPet ~= false then
                if string.find(data.IsPet, rcheck) then
                  local list = PS_GetListData(name);
                  if list ~= nil then
                    local data = name.."\n";
                    PS_thelist = string.gsub(PS_thelist, data, "");
                    PSvars.list[name] = nil;
                    encount = 2;
                  end
                end
              end
            end
          end
        end
      end
    end
    PS_remove = 0;
    if PS_tpos > 2 then
      PS_Clear_Popup();
      PS_dim = 1;
      PS_addpop = 0;
      local data = rcheck.."\n";
      PS_thelist = string.gsub(PS_thelist, data, "");
      listData.pos = 0;
      listData.time = 0;
      listData.phase = 0;
      listData.health = 0;
      listData.damage = 0;
      listData.heals = 0;
      listData.known = false;
      PSvars.list[data] = listData;
      if targetData ~= nil then
        if (targetData.IsEnemy and (PS_Enemy > (encount - 1)) and listData.known) then
          PS_Enemy = PS_Enemy - encount;
        end
      end
      PS_Process_Tooltip(PS_thelist);
    else
      PS_Clear_Popup();
      PS_ClearPvP();
      PS_thelist = "";
      PSvars.list = {};
      PS_Enemy = 0;
      rcheck = nil;
      return;
    end
    if targetData ~= nil then
      if targetData.Notes == "PvP2" then
        targetData.Notes = "";
        PSvars.Database[data] = targetData;
      end
    end
  end
end

function PS_DetectStealth()

  local targetData = PSvars.Database[PS_cchck];
  if ((PS_skipchk == 2 and PS_lastpinged == PS_cchck) or (PS_lastpinged == PS_cchck and PS_skipchk == 0 and PS_CombatMode == "")) then
    PS_skipchk = 0;
    return;
  end
  PS_stealth = false;
  local srace, sclass, setag, setmess;
  local targetData = PSvars.Database[PS_cchck];
  if targetData ~= nil then
    local level = targetData.Level;
    if ((targetData.IsEnemy and (targetData.Class == PS_ROGUE or targetData.Class == PS_DRUID)) or PS_skipchk ~= 0 or PS_CombatMode == "Com") then
      PS_stealth = true;
      if(PS_UserWantsToPing() or IsControlKeyDown()) then
        if (PS_X ~= 999 and PS_Y ~= 999) then
          Minimap:PingLocation(PS_X, PS_Y);
        end
      end
      if ((targetData.IsGuess or targetData.TooHigh) and level ~= 70) then
        level = level.."+";
      end
      if ((targetData.IsEnemy and (targetData.Class == PS_ROGUE or targetData.Class == PS_DRUID)) and PS_cchck ~= UnitName("target")) then
        setag = PS_WSE;
      elseif targetData.IsEnemy then
        setag = PS_WE;
      else
        setag = PS_DF;
      end
      if targetData.IsPlayer then
        setmess = PS_PLAYER;
        srace = " "..targetData.Race;
        sclass = " "..targetData.Class;
      else
        setmess = PS_NPLAYER;
        srace = "";
        sclass = "";
      end
      local Loc = GetMinimapZoneText();
      local x, y = GetPlayerMapPosition("player");
      x = math.floor(x*100);
      y = math.floor(y*100);
      local xy = x..", "..y;
      if PSvars.CustomWarning == "" then
        PS_sendmsg = setag..setmess..PS_cchck.." ("..level..srace..sclass..")"..PS_NEARBY..Loc.." ["..xy.."]";
      else
        PS_sendmsg = PSvars.CustomWarning;
        if not targetData.IsPlayer then
          PS_sendmsg = string.gsub(PS_sendmsg, ' %%c', "");
          PS_sendmsg = string.gsub(PS_sendmsg, ' %%r', "");
        end
        PS_sendmsg = string.gsub(PS_sendmsg, '%%w', setag..setmess);
        PS_sendmsg = string.gsub(PS_sendmsg, '%%n', PS_cchck);
        PS_sendmsg = string.gsub(PS_sendmsg, ' %%c', sclass);
        PS_sendmsg = string.gsub(PS_sendmsg, '%%l', level);
        PS_sendmsg = string.gsub(PS_sendmsg, ' %%r', srace);
        PS_sendmsg = string.gsub(PS_sendmsg, '%%x', xy);
        PS_sendmsg = string.gsub(PS_sendmsg, '%%z', Loc);
      end
    end
  else
    PS_skipchk = 0;
    return;
  end
end

function PS_Refresh(unitname, isplayer, isenemy, type, level, race, class, PS_id)

  if (PS_id < 2 or class == nil) then
    return;
  end
  local targetData = PSvars.Database[unitname];
  local listData = PSvars.list[unitname];
  if (targetData == nil or listData == nil) then
    return;
  end
  local petgrab = false;
  if (not isplayer and type ~= "Nil") then
    PS_GrabPet(unitname, isenemy, type);
    petgrab = true;
  end
  if (PSvars.SentrySound and targetData ~= nil) then
    if (targetData.IsEnemy and not listData.known and PS_Enemy == 0) then
      PS_Enemy = 1;
      PlaySoundFile("Sound\\Interface\\TalentScreenOpen.wav");
      listData.known = true;
      PSvars.list[unitname] = listData;
    elseif (targetData.IsEnemy and not listData.known) then
      PS_Enemy = PS_Enemy + 1;
      listData.known = true;
      PSvars.list[unitname] = listData;
      if (GetTime() - PS_ClickTime > 1) then
        PlaySoundFile("Sound\\Interface\\MouseOverTarget.wav");
      end
    end
    PS_ClickTime = GetTime();
  end
  if unitname == PS_SHADOWFIEND then
    race = "Illusionary";
  end
  if targetData.Race == "Unknown" then
    targetData.Race = race;
  end
  if type ~= "Nil" then
    listData.known = true;
    PSvars.list[unitname] = listData;
    if (not petgrab and not targetData.IsPet) then
      targetData.Race = race;
    end
    targetData.IsPlayer = isplayer;
    targetData.Level = level;
    targetData.IsGuess = false;
    if UnitClassification(type) == "elite" or UnitClassification(type) == "rare" or UnitClassification(type) == "rareelite" then
      targetData.Notes = UnitClassification(type);
    end
    PSvars.Database[unitname] = targetData;
  end
  if ((isplayer and targetData.Level ~= level) or (not isplayer and targetData.Level ~= level)) then
    targetData.Level = level;
    PSvars.Database[unitname] = targetData;
  end
  if (type == "Nil" and targetData.Level ~= 70 and (targetData.IsGuess or targetData.TooHigh)) then
    level = targetData.Level.."+";
  end
  if type == "Nil" then
    type = nil;
  end
  if targetData ~= nil then
    if targetData.IsKOS then
      if (targetData.IsPlayer and targetData.IsEnemy) then
        DEFAULT_CHAT_FRAME:AddMessage(PS_HPF..unitname, .4, 1, .2);
        if PSvars.SentrySound then
          PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitalert.wav");
        end
      else
        targetData.IsKOS = false;
        PSvars.Database[target] = targetData;
      end
    end
  end
  local button = getglobal("PS_PopupButton"..PS_id..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button");
  local bar = getglobal("PS_PopupButton"..PS_id..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar");
  local bg = getglobal("PS_PopupButton"..PS_id..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBGBar");
  local classicon = getglobal("PS_PopupButton"..PS_id..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon");
  local IsPet = false;
  local r, g, b, r1, g1, b1;
  if isplayer then
    if PS_CLASSES[targetData.Class] then
      classicon:SetTexCoord(unpack(PS_CLASSES[targetData.Class]));
    else
      classicon:SetTexCoord(0, .25, 0, .25);
    end
    classicon:SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes");
    message = unitname.." ("..level.." "..race.." "..class..")";
    if isenemy then
      r = PSvars.EnemyPlayer.r;
      g = PSvars.EnemyPlayer.g;
      b = PSvars.EnemyPlayer.b;
      r1 = PSvars.EnemyPlayerT.r;
      g1 = PSvars.EnemyPlayerT.g;
      b1 = PSvars.EnemyPlayerT.b;
    else
      r = PSvars.FriendlyPlayer.r;
      g = PSvars.FriendlyPlayer.g;
      b = PSvars.FriendlyPlayer.b;
      r1 = PSvars.FriendlyPlayerT.r;
      g1 = PSvars.FriendlyPlayerT.g;
      b1 = PSvars.FriendlyPlayerT.b;
    end
  else
    if targetData.Notes == "PvP" then
      message = unitname.." ("..level.." NPC PvP)";
    else
      message = unitname.." ("..level.." NPC)";
    end
    if isenemy then
      r = PSvars.EnemyNPC.r;
      g = PSvars.EnemyNPC.g;
      b = PSvars.EnemyNPC.b;
      r1 = PSvars.EnemyNPCT.r;
      g1 = PSvars.EnemyNPCT.g;
      b1 = PSvars.EnemyNPCT.b;
      classicon:SetTexCoord(0, 1, 0, 1);
      classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\npc");
    else
      r = PSvars.FriendlyNPC.r;
      g = PSvars.FriendlyNPC.g;
      b = PSvars.FriendlyNPC.b;
      r1 = PSvars.FriendlyNPCT.r;
      g1 = PSvars.FriendlyNPCT.g;
      b1 = PSvars.FriendlyNPCT.b;
      classicon:SetTexCoord(0, 1, 0, 1);
      classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\npc");
    end
  end
  if targetData.IsPet ~= nil then
    if (targetData.IsPet == true or (targetData.IsPet ~= false and not PSvars.GrabPet)) then
      if targetData.Race ~= nil then
        message = unitname.." ("..level.." "..targetData.Race.." Pet)";
        IsPet = true;
      else
        message = unitname.." ("..level.." NPC Pet)";
        IsPet = true;
      end
      if isenemy then
        r = PSvars.EnemyNPC.r;
        g = PSvars.EnemyNPC.g;
        b = PSvars.EnemyNPC.b;
        r1 = PSvars.EnemyNPCT.r;
        g1 = PSvars.EnemyNPCT.g;
        b1 = PSvars.EnemyNPCT.b;
        classicon:SetTexCoord(0, 1, 0, 1);
        classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\pet_unit");
      else
        r = PSvars.FriendlyNPC.r;
        g = PSvars.FriendlyNPC.g;
        b = PSvars.FriendlyNPC.b;
        r1 = PSvars.FriendlyNPCT.r;
        g1 = PSvars.FriendlyNPCT.g;
        b1 = PSvars.FriendlyNPCT.b;
        classicon:SetTexCoord(0, 1, 0, 1);
        classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\pet_unit");
      end
    elseif targetData.IsPet ~= false then
      if targetData.Race ~= nil then
        message = unitname.." ("..level.." "..targetData.Race.." "..targetData.IsPet.."'s Pet)";
        IsPet = true;
      else
        message = unitname.." ("..level.." "..targetData.IsPet.."'s Pet)";
        IsPet = true;
      end
      if isenemy then
        r = PSvars.EnemyNPC.r;
        g = PSvars.EnemyNPC.g;
        b = PSvars.EnemyNPC.b;
        r1 = PSvars.EnemyNPCT.r;
        g1 = PSvars.EnemyNPCT.g;
        b1 = PSvars.EnemyNPCT.b;
        classicon:SetTexCoord(0, 1, 0, 1);
        classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\pet_unit");
      else
        r = PSvars.FriendlyNPC.r;
        g = PSvars.FriendlyNPC.g;
        b = PSvars.FriendlyNPC.b;
        r1 = PSvars.FriendlyNPCT.r;
        g1 = PSvars.FriendlyNPCT.g;
        b1 = PSvars.FriendlyNPCT.b;
        classicon:SetTexCoord(0, 1, 0, 1);
        classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\pet_unit");
      end
    end
  end
  if targetData.Notes ~= nil then
    if targetData.Notes ~= "PvP" and targetData.Notes ~= "" then
      if targetData.Notes == "elite" then
        message = unitname.." ("..level.." NPC Elite)";
        if isenemy then
          r = PSvars.EnemyNPC.r;
          g = PSvars.EnemyNPC.g;
          b = PSvars.EnemyNPC.b;
          r1 = PSvars.EnemyNPCT.r;
          g1 = PSvars.EnemyNPCT.g;
          b1 = PSvars.EnemyNPCT.b;
          classicon:SetTexCoord(0, 1, 0, 1);
          classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\1337");
        else
          r = PSvars.FriendlyNPC.r;
          g = PSvars.FriendlyNPC.g;
          b = PSvars.FriendlyNPC.b;
          r1 = PSvars.FriendlyNPCT.r;
          g1 = PSvars.FriendlyNPCT.g;
          b1 = PSvars.FriendlyNPCT.b;
          classicon:SetTexCoord(0, 1, 0, 1);
          classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\1337");
        end
      elseif targetData.Notes == "rare" or targetData.notes == "rareelite" then
        if targetData.Notes == "rare" then
          message = unitname.." ("..level.." NPC Rare)";
        else
          message = unitname.." ("..level.." NPC Rare-Elite)";
        end
        if isenemy then
          r = PSvars.EnemyNPC.r;
          g = PSvars.EnemyNPC.g;
          b = PSvars.EnemyNPC.b;
          r1 = PSvars.EnemyNPCT.r;
          g1 = PSvars.EnemyNPCT.g;
          b1 = PSvars.EnemyNPCT.b;
          classicon:SetTexCoord(0, 1, 0, 1);
          classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\rare");
        else
          r = PSvars.FriendlyNPC.r;
          g = PSvars.FriendlyNPC.g;
          b = PSvars.FriendlyNPC.b;
          r1 = PSvars.FriendlyNPCT.r;
          g1 = PSvars.FriendlyNPCT.g;
          b1 = PSvars.FriendlyNPCT.b;
          classicon:SetTexCoord(0, 1, 0, 1);
          classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\rare");
        end
      end
    end
  end
  getglobal("PS_PopupButton"..PS_id..PS_CombatMode..PS_Split..PSvars.PopupMode):SetBackdropBorderColor(r, g, b);
  bar:SetStatusBarColor(r, g, b, 1);
  bg:SetStatusBarColor(r, g, b, .1);
  local health = 100;
  if type ~= nil then
    health = UnitHealth(type);
  end
  if PSvars.CustomPopup ~= "" then
    message = PSvars.CustomPopup;
    if (targetData.Notes == "elite" or targetData.Notes == "rare" or targetData.notes == "rareelite" or (targetData.Notes == "PvP" and not targetData.IsPet)) then
      if targetData.Notes == "elite" then
        message = string.gsub(message, '%%c', "Elite");
      elseif targetData.Notes == "rare" then
        message = string.gsub(message, '%%c', "Rare");
      elseif targetData.Notes == "rareelite" then
        message = string.gsub(message, '%%c', "Rare-Elite");
      elseif not isplayer then
        message = string.gsub(message, '%%c', "PvP");
      end
    end
    if targetData.IsPet ~= nil then
      if (targetData.IsPet == true or (targetData.IsPet ~= false and not PSvars.GrabPet)) then
        message = string.gsub(message, '%%c', "Pet");
        IsPet = true;
      elseif targetData.IsPet ~= false then
        message = string.gsub(message, '%%c', targetData.IsPet.."'s Pet");
        IsPet = true;
      end
    end
    if string.find(message, '%%c') then
      if race == nil then
        message = string.gsub(message, ' %%c', "");
        message = string.gsub(message, '%%c ', "");
        message = string.gsub(message, '%%c', "");
      else
        message = string.gsub(message, '%%c', class);
      end
    end
    if targetData.Race == nil then
      message = string.gsub(message, '%%r', "NPC");
    else
      message = string.gsub(message, '%%r', targetData.Race);
    end
    message = string.gsub(message, '%%n', unitname);
    message = string.gsub(message, '%%l', level);
    if string.find(message, "nohealth") then
      health = 0;
      message = string.gsub(message, ' nohealth', "");
      message = string.gsub(message, 'nohealth ', "");
      message = string.gsub(message, 'nohealth', "");
    end
  end
  if (PSvars.ClassTextcolors and not IsPet) then
    if (targetData.Class ~= nil and targetData.Class ~= "" and targetData.Race ~= nil) then
      local colorData = popup_class_color[targetData.Class];
      r1 = colorData.r;
      g1 = colorData.g;
      b1 = colorData.b;
    end
  end
  if (PSvars.ClassBGcolors and not IsPet) then
    if (targetData.Class ~= nil and targetData.Class ~= "" and targetData.Race ~= nil) then
      local colorData = popup_class_color[targetData.Class];
      bar:SetStatusBarColor(colorData.r - .35, colorData.g - .35, colorData.b - .35, 1);
      bg:SetStatusBarColor(colorData.r - .35, colorData.g - .35, colorData.b - .35, .1);
    end
  end
  button:SetTextColor (r1, g1, b1);
  if (health == 0 and not PSvars.DeathDetect) then
    health = 100;
  end
  bar:SetValue(health);
  button:SetText(message);
  button.PS_ID = PS_id;
  button.PS_DATA = unitname;
  button:GetParent():Show();
  button:Show();
  PS_width = PS_neww;
  local w = button:GetTextWidth();
  if w > PS_width then
    PS_width = w;
    PS_neww = PS_width;
  end
  PS_Display_Popup(PS_width + 10);
  if type ~= nil then
    if (UnitIsDeadOrGhost(type) and PSvars.DeathDetect) then
      PS_DeathDetect(unitname);
    end
  end
end

function PS_CombatSentryEvent(name)

  if PS_tpos < PSvars.MaxTargets then
    PS_addpop = 1;
    PS_CSG = 1;
    PS_Process_Tooltip(name);
  end
end

function PS_CaptureAttack(unitName, targetName, damage, type, skipcheck, pvp, spell)

  if skipcheck == 99 and (PSvars.MO == "ALL PLAYERS" or PSvars.MO == "ENEMY PLAYERS") then
    return;
  end
  local listData = PS_GetListData(unitName);
  local targetData = PS_GetUnitData(unitName);
  if (unitName == "YOU") then
    unitName = UnitName("player");
  end
  if (targetName == "YOU") then
    targetName = UnitName("player");
  end
  if (unitName == nil or unitName == UnitName("pet") or unitName == UnitName("player")) then
    return;
  end
  if type == "DoT" then
    type = nil;
    if listData.pos < 2 then
      return;
    end
  end
  if targetName then
    if (string.find(unitName, PS_TOTEM)) then
      return;
    end
  end
  if (string.find(unitName, PS_SQUIRREL) or string.find(unitName, PS_TOTEM) or string.find(unitName, PS_TRAP) or string.find(unitName, PS_SPIRIT)) then
    return;
  end
  PSvars.party = {};
  PSvars.partypet = {};
  for i=1, GetNumPartyMembers(), 1 do
    PSvars.party[i] = UnitName("party"..i);
    PSvars.partypet[i] = UnitName("partypet"..i);
    if (unitName == PSvars.party[i] or unitName == PSvars.partypet[i]) then
      if type ~= nil then
        targetData.IsGuess = false;
        if unitName == PSvars.party[i] then
          targetData.IsPlayer = true;
          targetData.Race = PS_UnitRace(type);
        else
          targetData.IsPlayer = false;
          if not targetData.IsPet then
            targetData.IsPet = true;
            targetData.Race = UnitCreatureType(type);
          end
        end
        targetData.IsEnemy = false;
        targetData.Class = PS_UnitClass(type);
        targetData.Level = UnitLevel(type);
        PSvars.Database[unitName] = targetData;
      end
      return;
    end
  end
  local heals = 0;
  if (damage and pvp) then
    heals = damage;
    damage = nil;
  end
  local lvl, cls, race, isenemy, isplayer;
  local ispvp = false;
  local known = true;
  local guess = false;
  if not listData.known then
    known = false;
  end
  if ((PS_tpos < PSvars.MaxTargets and type ~= nil) or skipcheck == 1) then
    lvl = UnitLevel(type);
    cls = PS_UnitClass(type);
    race = PS_UnitRace(type);
    if type ~= nil then
      local faction = UnitFactionGroup(type);
      local iselite = UnitClassification(type);
      ispvp = UnitIsPVP(type);
      isenemy = UnitIsEnemy(type, "player");
      isplayer = UnitIsPlayer(type);
      targetData.IsPlayer = isplayer;
      targetData.IsEnemy = isenemy;
      targetData.Class = cls;
      if ((not targetData.IsPet or cls == PS_DRUID or cls == PS_SHAMAN) and targetData.Race ~= "Unknown") then
        targetData.IsPet = false;
        targetData.Race = race;
      end
      local lvl2 = targetData.Level;
      if lvl2 == 0 then
        targetData.Level = lvl;
      end
      if (lvl == lvl2 and targetData.IsGuess) then
        lvl2 = -2;
      end
      if isplayer then
        if IsActiveBattlefieldArena() then
          targetData.IsTemp = true;
        else
          targetData.IsTemp = PS_bgmode;
        end
      end
      targetData.Zone = GetRealZoneText();
      targetData.SubZone = GetSubZoneText();
      if skipcheck == 2 then
        targetData.Hide = false;
        targetData.Notes = "PvP2";
      end
      if ispvp then
        targetData.Notes = "PvP";
      elseif (skipcheck ~= 2 and not ispvp and targetData.Notes ~= "PvP2") then
        targetData.Notes = "";
      end
      if (iselite == "rare" or iselite == "elite" or iselite == "rareelite") then
        targetData.Notes = iselite;
      else
        iselite = false;
      end
      if ((PSvars.storage == "PLAYERS" and not isplayer) or (PSvars.storage == "NPC" and isplayer) or PSvars.storage == "NONE") then
        targetData.IsTemp = true;
      end
      if (targetData.TooHigh and lvl ~= -1) then
        targetData.TooHigh = false;
      end
      if (targetData.IsGuess and lvl ~= -1) then
        guess = true;
        targetData.IsGuess = false;
      end
      if lvl == -1 then
        if (isplayer and PS_MyLevel > 59) then
          lvl = 70;
          targetData.Level = 70;
          targetData.TooHigh = false;
          targetData.IsGuess = false;
        elseif (lvl2 < (PS_MyLevel + 10)) then
          targetData.TooHigh = PS_MyLevel;
          targetData.IsGuess = false;
          lvl = PS_MyLevel + 10;
        elseif targetData.TooHigh then
          targetData.IsGuess = false;
          lvl = PS_MyLevel + 10;
        end
      end
      PSvars.Database[unitName] = targetData;
      if (PSvars.MO == "FLAGGED AND ELITE ENEMIES" and targetData.Notes ~= "" and targetData.NPC) then
        targetData.NPC = false;
      end
      if (targetData.Hide or (not PSvars.ShowPet and targetData.IsPet) or (PSvars.MO == "ALL" and ((targetData.IsPlayer or targetData.IsPet) and targetData.Notes == "")) or (PSvars.MO == "ENEMY PLAYERS" and (not isplayer or not isenemy or targetData.Notes == "")) or (PSvars.MO == "ALL PLAYERS" and (not isplayer or targetData.Notes == "")) or (PSvars.MO == "ENEMIES" and (not isenemy or (isenemy and ((isplayer or targetData.IsPet) and targetData.Notes == "")))) or (PSvars.MO == "FLAGGED AND ELITE ENEMIES" and (not isenemy or targetData.Notes == ""))) then
        if listData.pos > 1 then
          targetData.Level = lvl;
          if not targetData.IsPet then
            targetData.Race = race;
          end
          PSvars.Database[unitName] = targetData;
          PS_remove = 1;
          PS_RemoveTarget(unitName);
          return;
        else
          return;
        end
      end
      if (listData.pos > 1 and (not listData.known or targetData.Race == "Unknown" or lvl ~= lvl2 or guess)) then
        PS_Refresh(unitName, isplayer, isenemy, type, lvl, race, cls, listData.pos);
      elseif listData.pos == 0 then
        targetData.Level = lvl;
        if not targetData.IsPet then
          targetData.Race = race;
        end
        PSvars.Database[unitName] = targetData;
        PS_CombatSentryEvent(unitName);
      end
    end
  elseif (targetData.IsPet and not PSvars.ShowPet) then
    return;
  elseif (PS_tpos < PSvars.MaxTargets and (listData.pos == 0 or not listData.known or targetData.IsGuess or targetData.Race == "Unknown")) then
    if skipcheck == 99 then
      if (PSvars.MO == "FLAGGED AND ELITE ENEMIES" and targetData.NPC) then
        return;
      else
        if PSvars.MO == "FLAGGED AND ELITE ENEMIES" then
          targetData.NPC = true;
        end
        targetData.IsPlayer = false;
        targetData.IsEnemy = true;
      end
      PSvars.Database[unitName] = targetData;
    elseif (spell and (not listData.known or (targetData.IsEnemy and targetData.IsGuess))) then
      if (PSvars.GrabSpell and PS_AbilityList[spell] ~= nil) then
        if (not PS_AbilityList[spell].Race) then
          cls = PS_AbilityList[spell].Class;
        end
        if (PS_AbilityList[spell].Level > targetData.Level and (not listData.known or targetData.IsGuess)) then
          lvl = PS_AbilityList[spell].Level;
        else
          lvl = targetData.Level;
        end
        if targetData.Class == "" then
          targetData.Class = cls;
        end
        if PS_ZoneIsABG(GetRealZoneText()) then
          if PS_DetermineBGLevel(PS_MyLevel) > lvl then
            lvl = PS_DetermineBGLevel(PS_MyLevel);
          end
        end
        if (targetData.Race == "" or targetData.Race == "Unknown") then
          race = "Unknown";
          if PS_AbilityList[spell].Race then
            race = PS_AbilityList[spell].Race;
          end
          targetData.Race = race;
        else
          race = targetData.Race;
        end
        if IsActiveBattlefieldArena() then
          targetData.IsTemp = true;
        else
          targetData.IsTemp = PS_bgmode;
        end
        targetData.IsEnemy = true;
        targetData.IsPlayer = true;
        PSvars.Database[unitName] = targetData;
        if (listData.pos > 1 and (skipcheck == 3 or not listData.known or (targetData.Race == "Unknown" and race ~= "Unknown") or (targetData.IsGuess and targetData.Level < lvl))) then
          PS_Refresh(unitName, true, true, "Nil", lvl, race, cls, listData.pos);
        end
      end
    end
    if listData.pos == 0 then
      PS_CombatSentryEvent(unitName);
    end
  end
  listData = PS_GetListData(unitName);
  local heals2 = nil;
  if listData.pos > 1 then
    listData.phase = .8;
    listData.time = GetTime();
    targetData.DayNum = date("%j");
    PSvars.Database[unitName] = targetData;
    if (heals and targetName and PSvars.AutoNotify == "DAMAGE") then
      local healData = PS_GetListData(targetName);
      local checkData = PS_GetUnitData(targetname);
      if (healData ~= nil and checkData ~= nil) then
        if (healData.pos > 1 and (checkData.IsKOS or healData.damage)) then
          heals2 = heals;
        end
      end
    elseif heals then
      heals2 = heals;
    end
    if (targetData.IsPlayer and targetData.IsEnemy and (heals ~= 0 or damage ~= nil or targetData.IsKOS or ispvp)) then
      PS_AutoNotify(unitName, targetData.Class, targetData.Race, targetData.Level, damage, targetData.IsKOS, known, heals2);
    end
  end
  if (pvp and targetData.IsEnemy) then
    if pvp == 1 then
      if (targetData.IsPlayer and (targetData.Class == PS_PRIEST or targetData.Class == PS_SHAMAN or targetData.Class == PS_DRUID or targetData.Class == PS_PALADIN)) then
        listData.Heal = GetTime();
        if listData.heals == 0 then
          listData.heals = heals;
        else
          listData.heals = listData.heals + heals;
        end
      end
    else
      listData.Healed = GetTime();
    end
  end
  if (PSvars.Damage and damage ~= nil and targetData ~= nil) then
    if tonumber(listData.damage) == 0 then
      listData.damage = damage;
    else
      listData.damage = listData.damage + damage;
    end
  end
  PSvars.list[unitName] = listData;
end

function PS_DetermineBGLevel(level)

  local zone = GetRealZoneText();
  if zone == PS_ALTERAC_VALLEY then
    if level < 61 then
      return 51;
    else
      return 61;
    end
  end
  if zone == PS_EYE_OF_THE_STORM then
    if level < 70 then
      return 61;
    else
      return 70;
    end
  end
  if level < 20 then
    return 10;
  elseif level < 30 then
    return 20;
  elseif level < 40 then
    return 30;
  elseif level < 50 then
    return 40;
  elseif level < 60 then
    return 50;
  elseif level < 70 then
    return 60;
  else
    return 70;
  end
end

function PS_DeathDetect(name)

  if PS_DeathName ~= "" then
    for target in string.gmatch(PS_DeathName,"[^\n]*") do
      if string.len(target) > 0 then
        if target == name then
          return;
        end
      end
    end
  end
  PS_DeathTime = GetTime();
  PS_DeathName = PS_DeathName..name.."\n";
end

function PS_DeathDetect2(name)

  PS_DeathTime = nil;
  PS_DeathName = "";
  local templist = "";
  local listData = PS_GetListData(name);
  local targetData = PS_GetUnitData(name);
  if not PSvars.DeathDetect then
    listData.health = 100;
    PSvars.list[name] = listData;
  else
    if (name == UnitName("target") and not UnitIsDeadOrGhost("target")) then
      return;
    else
      PS_remove = 2;
      PS_RemoveTarget(name);
    end
  end
end

function PS_UserWantsToPing(check)

  if not PSvars.tracker then
    return false;
  end
  if PSvars.PingMode == "DEFAULT" then
    return true;
  end
  if (PSvars.PingMode == "OUTSIDE BG" and not PS_ZoneIsABG(GetRealZoneText()) and not IsActiveBattlefieldArena()) then
    return true;
  end
  if (PSvars.PingMode == "INSIDE BG" and (PS_ZoneIsABG(GetRealZoneText()) or IsActiveBattlefieldArena())) then
    return true;
  end
  if (PSvars.PingMode == "WHEN ANNOUNCING" and (PS_cchck ~= nil or check ~= nil)) then
    return true;
  end
  return false;
end

function PS_LoadSavedVariables()

  if not PSvars then
    PSvars = {};
    PSvars.DBVersion = 4;
  end
  if PSvars.ClearEnter == nil then
    PSvars.ClearEnter = true;
  end
  if PSvars.HitListExpire == nil then
    PSvars.HitListExpire = 90;
  end
  if PSvars.HealTime == nil then
    PSvars.HealTime = 20;
  end
  if PSvars.Healer == nil then
    PSvars.Healer = true;
  end
  if PSvars.ShowPet == nil then
    PSvars.ShowPet = true;
  end
  if PSvars.GrabSpell == nil then
    PSvars.GrabSpell = true;
  end
  if PSvars.AutoNotify == nil then
    PSvars.AutoNotify = false;
  end
  if PSvars.GrabPet == nil then
    PSvars.GrabPet = true;
  end
  if PSvars.ClassBGcolors == nil then
    PSvars.ClassBGcolors = true;
  end
  if PSvars.ClassTextcolors == nil then
    PSvars.ClassTextcolors = true;
  end
  if PSvars.CustomWarning == nil then
    PSvars.CustomWarning = "";
  end
  if PSvars.CustomPopup == nil then
    PSvars.CustomPopup = "";
  end
  if string.find(PSvars.CustomPopup, '%%p') then
    PSvars.CustomPopup = string.gsub(PSvars.CustomPopup, ' %%p', "");
    PSvars.CustomPopup = string.gsub(PSvars.CustomPopup, '%%p ', "");
    PSvars.CustomPopup = string.gsub(PSvars.CustomPopup, '%%p', "");
  end
  if PSvars.Damage == nil then
    PSvars.Damage = true;
  end
  if string.find(PSvars.CustomPopup, '%%d') then
    PSvars.Damage = true;
    PSvars.CustomPopup = string.gsub(PSvars.CustomPopup, ' %%d', "");
    PSvars.CustomPopup = string.gsub(PSvars.CustomPopup, '%%d ', "");
    PSvars.CustomPopup = string.gsub(PSvars.CustomPopup, '%%d', "");
  end
  if PSvars.tracking == nil then
    PSvars.tracking = "ALL";
  end
  if PSvars.MO == nil then
    PSvars.MO = "ALL";
  end
  if PSvars.Xicon == nil then
    PSvars.Xicon = 0;
    PSvars.Yicon = 0;
  end
  if PSvars.KeepBG == nil then
    PSvars.KeepBG = false;
  end
  if PSvars.Split == nil then
    PSvars.Split = true;
  end
  if PSvars.MaxTargets == nil then
    PSvars.MaxTargets = 21;
  end
  if PSvars.MiniIcon == nil then
    PSvars.MiniIcon = 2;
  elseif (PSvars.MiniIcon ~= 0 and PSvars.MiniIcon ~= 1 and PSvars.MiniIcon ~= 2) then
    PSvars.MiniIcon = 2;
  end
  if PSvars.DownT == nil then
    PSvars.DownT = 700;
    PSvars.DownL = 700;
  end
  if PSvars.UpT == nil then
    PSvars.UpT = 400;
    PSvars.UpL = 200;
  end
  if not PSvars.Database then
    local count = 0;
    PSvars.Database = {};
    if PS_faction == "Alliance" then
      if PSvars.EnemyPlayers ~= nil then
        for name, data in pairs(PSvars.EnemyPlayers) do
          data.IsEnemy = true;
          data.IsPlayer = true;
          PSvars.Database[name] = data;
          count = count + 1;
        end
        PSvars.EnemyPlayers = nil;
      end
      if PSvars.EnemyMobs ~= nil then
        for name, data in pairs(PSvars.EnemyMobs) do
          data.IsEnemy = true;
          data.IsPlayer = false;
          PSvars.Database[name] = data;
          count = count + 1;
        end
        PSvars.EnemyMobs = nil;
      end
      if PSvars.FriendlyPlayers ~= nil then
        for name, data in pairs(PSvars.FriendlyPlayers) do
          data.IsEnemy = false;
          data.IsPlayer = true;
          PSvars.Database[name] = data;
          count = count + 1;
        end
        PSvars.FriendlyPlayers = nil;
      end
      if PSvars.FriendlyMobs ~= nil then
        for name, data in pairs(PSvars.FriendlyMobs) do
          data.IsEnemy = false;
          data.IsPlayer = false;
          PSvars.Database[name] = data;
          count = count + 1;
        end
        PSvars.FriendlyMobs = nil;
      end
    else
      if PSvars.EnemyP ~= nil then
        for name, data in pairs(PSvars.EnemyP) do
          data.IsEnemy = true;
          data.IsPlayer = true;
          PSvars.Database[name] = data;
          count = count + 1;
        end
        PSvars.EnemyP = nil;
      end
      if PSvars.EnemyM ~= nil then
        for name, data in pairs(PSvars.EnemyM) do
          data.IsEnemy = true;
          data.IsPlayer = false;
          PSvars.Database[name] = data;
          count = count + 1;
        end
        PSvars.EnemyM = nil;
      end
      if PSvars.FriendlyP ~= nil then
        for name, data in pairs(PSvars.FriendlyP) do
          data.IsEnemy = false;
          data.IsPlayer = true;
          PSvars.Database[name] = data;
          count = count + 1;
        end
        PSvars.FriendlyP = nil;
      end
      if PSvars.FriendlyM ~= nil then
        for name, data in pairs(PSvars.FriendlyM) do
          data.IsEnemy = false;
          data.IsPlayer = false;
          PSvars.Database[name] = data;
          count = count + 1;
        end
        PSvars.FriendlyM = nil;
      end
    end
    if count > 1 then
      DEFAULT_CHAT_FRAME:AddMessage("Personal Sentry database successfully converted! ("..count.." entries)", 1, .3 ,0);
    end
  end
  for name, data in pairs(PSvars.Database) do
    if data.DayNum == nil then
      data.DayNum = date("%j");
    end
    data.LastSeen = nil;
    if data.Level == -2 then
      data.Level = PS_DetermineBGLevel(PS_MyLevel);
    end
    if data.Level == -1 then
      data.Level = PS_MyLevel;
      data.IsGuess = true;
    end
    PSvars.Database[name] = data;
  end
  if PSvars.DeathDetect == nil then
    PSvars.DeathDetect = true;
  end
  if PSvars.scale == nil then
    PSvars.scale = .85;
  end
  if PSvars.PopupMode == nil then
    PSvars.PopupMode = "DOWNWARD";
  end
  if PSvars.MinimapIconPos == nil then
    PSvars.MinimapIconPos = 45;
  end
  if PSvars.ColorMode == nil then
    PSvars.ColorMode = "CLASS LEVEL";
  end
  if PSvars.storage == nil then
    PSvars.storage = "ALL";
  end
  if PSvars.announce == nil then
    PSvars.announce = "AUTO";
  end
  if PSvars.announce == "GROUP" then
    PSvars.announce = "PARTY";
  end
  if PSvars.Locked == nil then
    PSvars.Locked = false;
  end
  if PSvars.BGMode == nil then
    PSvars.BGMode = true;
  end
  if PSvars.PingMode == nil then
    PSvars.PingMode = "DEFAULT";
  end
  if PSvars.SentryMode == nil then
    PSvars.SentryMode = true;
  end
  if PSvars.SetTime == nil then
    PSvars.SetTime = 60;
  end
  if PSvars.Addons == nil then
    PSvars.Addons = "ON";
  end
  if PSvars.SentrySound == nil then
    PSvars.SentrySound = true;
  end
  if PSvars.SentryChk == nil then
    PSvars.SentryChk = false;
  end
  local playerClass = PS_UnitClass("player");
  if (playerClass == PS_HUNTER or playerClass == PS_DRUID or playerClass == PS_WARLOCK) then
    PSvars.tracker = true;
  else
    PSvars.tracker = false;
  end
  if PSvars.EnemyPlayer == nil then
    PSvars.EnemyPlayer = {};
    PSvars.EnemyPlayer.r = 1;
    PSvars.EnemyPlayer.g = 0;
    PSvars.EnemyPlayer.b = 0;
    PSvars.EnemyNPC = {};
    PSvars.EnemyNPC.r = 1;
    PSvars.EnemyNPC.g = .3;
    PSvars.EnemyNPC.b = .3;
    PSvars.FriendlyPlayer = {};
    PSvars.FriendlyPlayer.r = 0;
    PSvars.FriendlyPlayer.g = 1;
    PSvars.FriendlyPlayer.b = 0;
    PSvars.FriendlyNPC = {};
    PSvars.FriendlyNPC.r = .3;
    PSvars.FriendlyNPC.g = 1;
    PSvars.FriendlyNPC.b = .3;
    PSvars.UNKPlayer = {};
    PSvars.UNKPlayer.r = 1;
    PSvars.UNKPlayer.g = .95;
    PSvars.UNKPlayer.b = .37;
    PSvars.UNKNPC = {};
    PSvars.UNKNPC.r = .8;
    PSvars.UNKNPC.g = .75;
    PSvars.UNKNPC.b = .3;
  end
  if PSvars.EnemyPlayerT == nil then
    PSvars.EnemyPlayerT = {};
    PSvars.EnemyPlayerT.r = 1;
    PSvars.EnemyPlayerT.g = .35;
    PSvars.EnemyPlayerT.b = .35;
    PSvars.EnemyNPCT = {};
    PSvars.EnemyNPCT.r = 1;
    PSvars.EnemyNPCT.g = .65;
    PSvars.EnemyNPCT.b = .65;
    PSvars.FriendlyPlayerT = {};
    PSvars.FriendlyPlayerT.r = .35;
    PSvars.FriendlyPlayerT.g = 1;
    PSvars.FriendlyPlayerT.b = .35;
    PSvars.FriendlyNPCT = {};
    PSvars.FriendlyNPCT.r = .65;
    PSvars.FriendlyNPCT.g = 1;
    PSvars.FriendlyNPCT.b = .65;
    PSvars.UNKPlayerT = {};
    PSvars.UNKPlayerT.r = 1;
    PSvars.UNKPlayerT.g = 1;
    PSvars.UNKPlayerT.b = .72;
    PSvars.UNKNPCT = {};
    PSvars.UNKNPCT.r = 1;
    PSvars.UNKNPCT.g = 1;
    PSvars.UNKNPCT.b = .6;
  end
end

function PS_ZoneIsABG(zone)

  local isbg = false;
  for i = 1, table.getn(PS_BGZones) do
    if string.find(zone, PS_BGZones[i]) then
      isbg = true;
    end
  end
  return isbg;
end

function PS_PurgeTempEntries()

  local purged = 0;
  for name, data in pairs(PSvars.Database) do
    if data.DayNum == nil then
      data.DayNum = date("%j") - 1;
    end
    if data.NPC then
      data.NPC = false;
    end
    if data.notified then
      data.notified = false;
    end
    if data.IsTemp ~= nil then
      if data.IsTemp == true then
        if not data.IsKOS then
          PSvars.Database[name] = nil;
          purged = purged + 1;
        end
        local fixit = date("%j") - data.DayNum;
        if fixit < 0 then
          fixit = 365 - data.DayNum + fixit;
        end
        if (fixit == PSvars.HitListExpire or fixit > PSvars.HitListExpire) then
          data.IsKOS = false;
          PSvars.Database[name] = data;
          DEFAULT_CHAT_FRAME:AddMessage(name..PS_RHL, 0, 1, 0);
          if PSvars.SentrySound then
            PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitremove.wav");
          end
        end
      end
    end
    if data.IsPlayer then
      if ((date("%j") - data.DayNum ~= 0) and data.Level < 70) then
        data.IsGuess = true;
      end
      if data.Level == 70 then
        data.IsGuess = false;
      end
    end
    if data.TooHigh then
      if (data.TooHigh ~= PS_MyLevel and ((data.IsPlayer and data.Level < 70) or not data.IsPlayer)) then
        data.TooHigh = false;
        data.IsGuess = true;
      else
        data.IsGuess = false;
      end
    end
    if data.Hide ~= nil then
      data.Hide = false;
      PSvars.Database[name] = data;
    end
  end
  if purged > 0 then
    DEFAULT_CHAT_FRAME:AddMessage("Personal Sentry has purged "..purged.." temporary entries.", 1, 1 ,1);
  end
end

function PS_PurgePetEntries()

  for name, data in pairs(PSvars.Database) do
    if data.IsPet ~= true and data.IsPet ~= false then
      PSvars.Database[name] = nil;
    end
  end
end

function PS_ButtonClick()

  local target = nil;
  local data = this.PS_DATA;
  local PS_id = this.PS_ID;
  local targetData = PS_GetUnitData(data);
  local listData = PS_GetListData(data);
  PS_X = tonumber(this.PS_X);
  PS_Y = tonumber(this.PS_Y);
  if (arg1 == "RightButton" and PS_id ~= 1) then
    if IsShiftKeyDown() then
      PS_skipchk = 1;
    elseif UnitName("target") == data then
      PS_skipchk = 2;
    end
    PS_cchck = data;
    PS_DetectStealth();
  end
  if PS_id ~= 1 then
    if (arg1 == "LeftButton" and IsShiftKeyDown()) then
      if targetData.IsPet ~= nil then
        if (targetData.IsPet ~= true and targetData.IsPet ~= false) then
          this:SetAttribute("type", "macro");
          this:SetAttribute("macrotext", "/target "..targetData.IsPet);
          return;
        end
      end
      if (not targetData.IsKOS and targetData.IsEnemy and targetData.IsPlayer) then
        targetData.IsKOS = true;
        if targetData.DayNum == nil then
          targetData.DayNum = date("%j");
        end
        DEFAULT_CHAT_FRAME:AddMessage(data..PS_AHL, 1, .3, .6);
        if PSvars.SentrySound then
          PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitadd.wav");
        end
        PSvars.Database[data] = targetData;
        if PS_HitList:IsVisible() then
          PS_New_Hitlist(true);
        end
      elseif (targetData.IsKOS and targetData.IsEnemy and targetData.IsPlayer) then
        targetData.IsKOS = false;
        DEFAULT_CHAT_FRAME:AddMessage(data..PS_RHL, .3, 1, .6);
        if PSvars.SentrySound then
          PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitremove.wav");
        end
        PSvars.Database[data] = targetData;
        if PS_HitList:IsVisible() then
          PS_New_Hitlist(true);
        end
      end
    elseif ((arg1 == "LeftButton" and IsAltKeyDown()) or arg1 == "MiddleButton") then
      PS_remove = 1;
      PS_RemoveTarget(data);
      targetData.Hide = true;
      PSvars.Database[data] = targetData;
    end
    if PS_CombatMode == "" then
      PS_cchck2 = data;
      this:SetAttribute("type", "macro");
      this:SetAttribute("macrotext", "/target "..data);
      PS_remove = 3;
    end
  else
    PS_Clear_Popup();
    PS_ClearPvP();
    PS_thelist = "";
    PSvars.list = {};
    PS_Enemy = 0;
  end
end

function PS_ClearPvP()

  for target in string.gmatch(PS_thelist, "[^\n]*") do
    if string.len(target) > 0 then
    local targetData = PSvars.Database[target];
      if targetData ~= nil then
        if targetData.Notes == "PvP2" then
          targetData.Notes = "";
        end
        PSvars.Database[target] = targetData;
      end
    end
  end
end

function PS_DamButtonClick()

  local data = this.id;
  if data ~= nil then
    for target in string.gmatch(PS_thelist, "[^\n]*") do
      if string.len(target) > 0 then
        local listData = PS_GetListData(target);
        if listData.pos == data then
          listData.heals = 0;
          listData.Heal = false;
          listData.Healed = false;
          listData.damage = 0;
          PSvars.list[target] = listData;
          local button = getglobal("PS_PopupButton"..listData.pos..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode.."Button");
          button:SetText("");
          button:GetParent():Show();
          button:Show();
        end
      end
    end
  end
end

function PS_Notification(check)

  if (UnitName("target") ~= PS_cchck and PS_CombatMode ~= "Com" and not PS_stealth and not check) then
    return;
  else
    if(PS_UserWantsToPing(check) or IsControlKeyDown()) then
      if (PS_X ~= 999 and PS_Y ~= 999) then
        Minimap:PingLocation(PS_X, PS_Y);
      end
    end
    PS_lastpinged = PS_cchck;
    local place = GetZoneText();
    local speak, defchan;
    if place == nil then
      place = GetMinimapZoneText();
    end
    defchan = GetChannelName(PS_PLD.." - "..place);
    if (PS_bgmode or IsActiveBattlefieldArena() or defchan == 0) then
      defchan = nil;
    end
    if ((PSvars.announce == "LOCALDEFENSE" or PSvars.announce == "LDA") and defchan ~= nil) then
	speak = GetDefaultLanguage("player");
      if PSvars.announce == "LOCALDEFENSE" then
        SendChatMessage(PS_sendmsg,"CHANNEL", speak, defchan);
      elseif(GetNumRaidMembers() > 0 and not PS_bgmode and not IsActiveBattlefieldArena()) then
        SendChatMessage(PS_sendmsg, "RAID");
      elseif (GetNumPartyMembers() > 0 and not PS_bgmode and not IsActiveBattlefieldArena()) then
        SendChatMessage(PS_sendmsg, "PARTY");
      else
        SendChatMessage(PS_sendmsg,"CHANNEL", speak, defchan);
      end
    elseif PSvars.announce == "RAID" then
      SendChatMessage(PS_sendmsg, "RAID");
    elseif PSvars.announce == "GUILD" then
      SendChatMessage(PS_sendmsg, "GUILD");
    elseif PSvars.announce == "PARTY" then
      SendChatMessage(PS_sendmsg, "PARTY");
    elseif PSvars.announce == "YELL" then
      SendChatMessage(PS_sendmsg, "YELL");
    elseif PSvars.announce == "SAY" then
      SendChatMessage(PS_sendmsg, "SAY");
    elseif PSvars.announce == "AUTO" then
      if(GetNumRaidMembers() > 0 and not PS_bgmode and not IsActiveBattlefieldArena()) then
        SendChatMessage(PS_sendmsg, "RAID");
      elseif (GetNumPartyMembers() > 0 and not PS_bgmode and not IsActiveBattlefieldArena()) then
        SendChatMessage(PS_sendmsg, "PARTY");
      else
        SendChatMessage(PS_sendmsg, "SAY");
      end
    elseif PSvars.announce == "SELF" then
      DEFAULT_CHAT_FRAME:AddMessage(PS_sendmsg, 1, 1, 1);
    end
  end
end

function PS_AutoNotify(unitname, cls, rce, level, damage, IsKOS, known, heals)

  if (rce == nil or cls == nil or level == nil or level == 0 or PS_bgmode or IsActiveBattlefieldArena() or not PSvars.AutoNotify) then
    return;
  end
  local targetData = PSvars.Database[unitname];
  if targetData.notified then
    if (GetTime() - targetData.notified < 120) then
      return;
    end
  end
  if (rce == PS_NIGHTELF or rce == PS_DWARF or rce == PS_HUMAN or rce == PS_GNOME or rce == PS_DRAENEI) then
    if PS_faction == "Alliance" then
      return;
    end
  elseif (rce == PS_ORC or rce == PS_UNDEAD or rce == PS_TAUREN or rce == PS_TROLL or rce == PS_BLOODELF) then
    if PS_faction == "Horde" then
      return;
    end
  end
  local place = GetZoneText();
  local speak, defchan;
  for i = 1, table.getn(PS_NeutralZones) do
    if place == PS_NeutralZones[i] then
      return;
    end
  end
  local listData = PSvars.list[unitname];
  if listData == nil then
    return;
  end
  if heals then
    damage = heals;
  end
  if (listData.announce and not targetData.IsGuess and known) then
    listData.announce = false;
    PSvars.list[unitname] = listData;
  elseif (PSvars.AutoNotify == "DAMAGE" and not IsKOS and (not PSvars.Damage or damage == nil)) then
    return;
  end
  if targetData.IsGuess then
    listData.announce = true;
    PSvars.list[unitname] = listData;
    return;
  end
  if targetData.TooHigh then
    level = level.."+";
  end
  targetData.notified = GetTime();
  PSvars.Database[unitname] = targetData;
  local setag, setmess, srace, sclass;
  setag = PS_WE;
  setmess = PS_PLAYER;
  srace = " "..rce;
  sclass = " "..cls;
  local Loc = GetMinimapZoneText();
  local x, y = GetPlayerMapPosition("player");
  x = math.floor(x*100);
  y = math.floor(y*100);
  local xy = x..", "..y;
  if PSvars.CustomWarning == "" then
    PS_sendmsg = setag..setmess..unitname.." ("..level..srace..sclass..")"..PS_NEARBY..Loc.." ["..xy.."]";
  else
    PS_sendmsg = PSvars.CustomWarning;
    PS_sendmsg = string.gsub(PS_sendmsg, '%%w', setag..setmess);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%n', unitname);
    PS_sendmsg = string.gsub(PS_sendmsg, ' %%c', sclass);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%l', level);
    PS_sendmsg = string.gsub(PS_sendmsg, ' %%r', srace);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%x', xy);
    PS_sendmsg = string.gsub(PS_sendmsg, '%%z', Loc);
  end
  PS_Notification(true);
end

function PS_PreParseNames(names)

  if not PSvars.tracker then
    return names;
  end
  local ret = "";
  if(names == nil) then
    return;
  end
  local wasreturn = false;
  for target in string.gmatch(names, "[^\n]*") do
    if string.len(target) > 0 then
      ret = ret..PS_ColorizeTooltipText(target);
      wasreturn = false;
	else
      if not wasreturn then
        ret = ret.."\n";
        wasreturn = true;
      end
    end
  end
  return ret;
end

function PS_ColorizeTooltipText(target, hitlist)

  local color = "";
  targetData = PSvars.Database[target];
  if targetData == nil then
    color = PSvars.UNKPlayer;
  elseif (not targetData.IsPlayer and not targetData.IsEnemy) then
    color = PSvars.FriendlyNPC;
  elseif (not targetData.IsPlayer and targetData.IsEnemy) then
    color = PSvars.EnemyNPC;
  elseif (targetData.IsPlayer and targetData.IsEnemy) then
    color = PSvars.EnemyPlayer;
  else
    color = PSvars.FriendlyPlayer;
  end
  if targetData == nil then
    return '|c'..PS_GetHexColor(color)..target..'|r';
  else
    return '|c'..PS_GetHexColor(color)..target..'|r'..PS_GetClassColor(targetData, color, hitlist);
  end
end

function PS_GetHexColor(color)

  local rh = string.format("%x", color.r * 255);
  local gh = string.format("%x", color.g * 255);
  local bh = string.format("%x", color.b * 255);
  if string.len(rh) == 1 then
    rh = "0"..rh;
  end
  if string.len(gh) == 1 then
    gh = "0"..gh;
  end
  if string.len(bh) == 1 then
    bh = "0"..bh;
  end
  return "ff"..rh..gh..bh;
end

function PS_GetClassColor(data, color, hitlist)

  if ((not hitlist and PSvars.ColorMode == "NORMAL") or (data == nil or data.Class == nil or tooltip_class_color[data.Class] == nil)) then
    return "";
  end
  local level;
  if (data.IsGuess or data.TooHigh and (not data.IsPlayer or (data.IsPlayer and data.Level < 70))) then
    level = data.Level.."+";
  else
    level = data.Level;
  end
  if hitlist then
    return '|c'..tooltip_class_color[data.Class].." ["..level.." "..data.Race.." "..data.Class..']|r'
  elseif ((PSvars.ColorMode ~= "CLASS LEVEL" or level == nil or level == 0) and targetData.IsPlayer) then
    return '|c'..tooltip_class_color[data.Class].." ["..data.Class..']|r'
  elseif targetData.IsPlayer then
    return '|c'..tooltip_class_color[data.Class].." ["..level.." "..data.Class..']|r'
  elseif (not targetData.IsPlayer and (string.lower(data.Notes) == "elite" or data.Notes == "rare" or data.Note == "rareelite")) then
    if string.lower(data.Notes) == "elite" then
      return '|c'..PS_GetHexColor(color).." ["..level.." Elite"..']|r'
    elseif data.note == "rare" then
      return '|c'..PS_GetHexColor(color).." ["..level.." Rare"..']|r'
    else
      return '|c'..PS_GetHexColor(color).." ["..level.." Rare Elite"..']|r'
    end
  elseif PSvars.ColorMode == "CLASS LEVEL" then
    return '|c'..PS_GetHexColor(color)..' ['..level..']|r'
  else
    return "";
  end
end

function PS_Minimap_OnClick_Event()

  if (PSvars.tracker and (PSvars.Addons == "ON" or (PSvars.Addons == "BG" and PS_bgmode) or (PSvars.Addons == "NOBG" and not PS_bgmode and not IsActiveBattlefieldArena()) or (PSvars.Addons == "NOT ARENA" and not IsActiveBattlefieldArena()) or (PSvars.Addons == "NOT BG" and not PS_bgmode))) then
    if(PS_UserWantsToPing() or IsControlKeyDown()) then
      lOriginal_Minimap_OnClick_Event();
    end
    if GameTooltip:IsVisible() then
      local CCT = GetTrackingTexture();
      if CCT ~= nil then
        CCT = string.sub(CCT,17);
        if (CCT == "INV_Misc_Flower_02" or CCT == "Spell_Nature_Earthquake" or CCT == "Racial_Dwarf_FindTreasure") then
          return;
        end
      else
        return;
      end
      PS_starttime = GetTime();
      PS_mocheck = 3;
      PS_MMT = 1;
      local x, y = GetCursorPosition();
      x = x / Minimap:GetEffectiveScale();
      y = y / Minimap:GetEffectiveScale();
      local cx, cy = Minimap:GetCenter();
      if CURSOR_OFFSET_X ~= nil then
        PS_X = x + CURSOR_OFFSET_X - cx;
      else
        PS_X = x - cx;
      end
      if CURSOR_OFFSET_Y ~= nil then
        PS_Y = y + CURSOR_OFFSET_Y - cy;
      else
        PS_Y = y - cy;
      end
      if arg1 == "LeftButton" then
        PS_thelist = "";
        PSvars.list = {};
        PS_addpop = 0;
        PS_Enemy = 0;
        PS_Clear_Popup();
        PS_ClearPvP();
        PS_Process_Tooltip(GameTooltipTextLeft1:GetText());
      elseif arg1 == "RightButton" then
        if PS_tpos < PSvars.MaxTargets then
          PS_addpop = 1;
          PS_Process_Tooltip(GameTooltipTextLeft1:GetText());
        end
      end
    end
  else
    lOriginal_Minimap_OnClick_Event();
  end
end

function PS_MOCE2()

  if GameTooltip:IsVisible() then
    local CCT = GetTrackingTexture();
    if CCT ~= nil then
      CCT = string.sub(CCT,17);
      if (CCT == "INV_Misc_Flower_02" or CCT == "Spell_Nature_Earthquake" or CCT == "Racial_Dwarf_FindTreasure") then
        return;
      end
    else
      return;
    end
    PS_mocheck = 0;
    if PS_tpos < PSvars.MaxTargets then
      PS_addpop = 1;
      PS_MMT = 1;
      local x, y = GetCursorPosition();
      x = x / Minimap:GetEffectiveScale();
      y = y / Minimap:GetEffectiveScale();
      local cx, cy = Minimap:GetCenter();
      if CURSOR_OFFSET_X ~= nil then
        PS_X = x + CURSOR_OFFSET_X - cx;
      else
        PS_X = x - cx;
      end
      if CURSOR_OFFSET_Y ~= nil then
        PS_Y = y + CURSOR_OFFSET_Y - cy;
      else
        PS_Y = y - cy;
      end
      PS_Process_Tooltip(GameTooltipTextLeft1:GetText());
    end
  end
end

function PS_CompareTooltip(tooltip)

  if PS_dim == 1 then
    return PS_thelist;
  end
  PSvars.compare = {};
  local PS_newline = "";
  local tcount = 1;
  if (PS_addpop > 0 and PS_tpos > 1) then
    tcount = PS_tpos;
  end
  for target in string.gmatch(tooltip, "[^\n]*") do
    local good = false;
    target = PS_Process_Trg(target);
    if(string.len(target) > 0 and tcount < PSvars.MaxTargets) then
      local listData = PS_GetListData(target);
      local compareData = PS_GetCompareData(target);
      local targetData = PSvars.Database[target];
      if (PS_MMT == 0 and PS_SentryCheck) then
        if PSvars.MO == "ALL" then
          if targetData ~= nil then
            if (not targetData.IsPlayer or (targetData.IsPlayer and (targetData.Notes ~= "" or PS_CSG == 1))) then
              good = true;
            end
          end
        elseif PSvars.MO == "FLAGGED AND ELITE ENEMIES" then
          if targetData == nil then
            good = true;
          elseif (targetData.IsEnemy and (targetData.Notes ~= "" or ((targetData.IsPlayer or targetData.IsPet or targetData.NPC) and PS_CSG == 1))) then
            good = true;
          end
        elseif PSvars.MO == "ENEMY PLAYERS" then
          if targetData == nil then
            if not string.find(target, " ") then
              good = true;
            end
          elseif (targetData.IsPlayer and targetData.IsEnemy and (targetData.Notes ~= "" or PS_CSG == 1)) then
            if not string.find(target, " ") then
              good = true;
            end
          end
        elseif PSvars.MO == "ENEMIES" then
          if targetData == nil then
            good = true;
          elseif ((targetData.IsEnemy and not targetData.IsPlayer) or (targetData.IsEnemy and targetData.IsPlayer and (targetData.Notes ~= "" or PS_CSG == 1))) then
            good = true;
          end
        elseif PSvars.MO == "ALL PLAYERS" then
          if targetData == nil then
            if not string.find(target, " ") then
              good = true;
            end
          elseif (targetData.IsPlayer and (targetData.Notes ~= "" or PS_CSG == 1)) then
            if not string.find(target, " ") then
              good = true;
            end
          end
        end
        if (PSvars.tracker and not good) then
          if PSvars.tracking == "ALL" then
            if targetData ~= nil then
              good = true;
            end
          elseif PSvars.tracking == "FLAGGED AND ELITE ENEMIES" then
            if targetData == nil then
              good = true;
            elseif ((targetData.IsPlayer and targetData.IsEnemy) or (targetData.IsEnemy and targetData.Notes ~= "")) then
              good = true;
            end
          elseif PSvars.tracking == "ENEMY PLAYERS" then
            if targetData == nil then
              if not string.find(target, " ") then
                good = true;
              end
            elseif (targetData.IsPlayer and targetData.IsEnemy) then
              if not string.find(target, " ") then
                good = true;
              end
            end
          elseif PSvars.tracking == "ENEMIES" then
            if targetData == nil then
              good = true;
            elseif ((targetData.IsEnemy and not targetData.IsPlayer) or (targetData.IsEnemy and targetData.IsPlayer)) then
              good = true;
            end
          elseif PSvars.tracking == "ALL PLAYERS" then
            if targetData == nil then
              if not string.find(target, " ") then
                good = true;
              end
            elseif targetData.IsPlayer then
              if not string.find(target, " ") then
                good = true;
              end
            end
          end
        end
      else
        if (PSvars.tracker and not good) then
          if PSvars.tracking == "ALL" then
            good = true;
          elseif PSvars.tracking == "FLAGGED AND ELITE ENEMIES" then
            if targetData == nil then
              good = true;
            elseif ((targetData.IsEnemy and targetData.Notes ~= "") or (targetData.IsEnemy and targetData.IsPlayer)) then
              good = true;
            end
          elseif PSvars.tracking == "ENEMY PLAYERS" then
            if targetData == nil then
              if not string.find(target, " ") then
                good = true;
              end
            elseif (targetData.IsEnemy and targetData.IsPlayer) then
              if not string.find(target, " ") then
                good = true;
              end
            end
          elseif PSvars.tracking == "ENEMIES" then
            if targetData == nil then
              good = true;
            elseif targetData.IsEnemy then
              good = true;
            end
          elseif PSvars.tracking == "ALL PLAYERS" then
            if targetData == nil then
              if not string.find(target, " ") then
                good = true;
              end
            elseif targetData.IsPlayer then
              if not string.find(target, " ") then
                good = true;
              end
            end
          end
        end
        if targetData ~= nil then
          if targetData.IsPlayer then
            targetData.Notes = "PvP";
            PSvars.Database[target] = targetData;
          end
        end
      end
      PSvars.party = {};
      PSvars.partypet = {};
      if (target == UnitName("pet") or target == UnitName("player")) then
        good = false;
      end
      for i=1, GetNumPartyMembers() do
        PSvars.party[i] = UnitName("party"..i);
        PSvars.partypet[i] = UnitName("partypet"..i);
        if (target == PSvars.party[i] or target == PSvars.partypet[i]) then
          good = false;
        end
      end
      if targetData ~= nil then
        if (not PSvars.ShowPet and targetData.IsPet) then
          good = false;
        end
      end
      if (compareData.listed ~= 1 and good) then
        if targetData == nil then
          targetData = PS_GetEmptyTargetEntry();
        end
        if (listData.pos == 0 and tcount < PSvars.MaxTargets and not targetData.Hide) then
          PS_newline = PS_newline..target.."\n";
          compareData.listed = 1;
          PSvars.compare[target] = compareData;
          tcount = tcount + 1;
        end
      elseif (PS_addpop == 0 and (compareData.listed ~= 1 and not good)) then
        PSvars.list[target] = nil;
      elseif (targetData ~= nil and not good and compareData.listed == 1) then
        if (targetData.IsEnemy and PS_Enemy > 0) then
          PS_Enemy = PS_Enemy - 1;
        end
      end
    end
  end
  if PS_MMT == 1 then
    PS_newline = PS_CompareMapNames(PS_newline);
  end
  PS_MMT = 0;
  return PS_newline;
end

function PS_CompareMapNames(PS_newline)

  for i = 1, table.getn(PS_ZoneNames) do
    if string.find(PS_newline, PS_ZoneNames[i]) then
      PS_newline = string.gsub(PS_newline, PS_ZoneNames[i], "");
    end
  end
  for i = 1, table.getn(PS_OtherNames) do
    if string.find(PS_newline, PS_OtherNames[i]) then
      PS_newline = string.gsub(PS_newline, PS_OtherNames[i], "");
    end
  end
  if (PS_newline == nil or string.len(PS_newline) < 2) then
    PS_newline = "";
  end
  return PS_newline;
end

function PS_Process_Tooltip(tooltip)

  local line = nil;
  local pos = 0;
  local r, g, b;
  PS_width = 0;
  if PS_tpos < PSvars.MaxTargets then
    line = PS_CompareTooltip(tooltip);
    if ((line == "" or line == PS_thelist) and PS_dim == 0) then
      return;
    elseif (PS_dim == 0 and PS_addpop == 0) then
      PS_Clear_Popup();
    end
    if (PS_dim == 0 and (PS_addpop > 0 or ((PS_bgmode or IsActiveBattlefieldArena()) and PSvars.BGMode == "BG") or (not PS_bgmode and not IsActiveBattlefieldArena() and PSvars.BGMode == "NOBG") or PSvars.BGMode == true)) then
      pos = PS_tpos;
      PS_width = PS_neww;
      PS_thelist = PS_thelist..line;
    else
      PS_thelist = line;
    end
  else
    return;
  end
  if pos == 0 then
    pos = 1;
    message = PS_CLEAR;
    local button = getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button");
    local bar = getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar");
    local bg = getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBGBar");
    local classicon = getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon");
    if PSvars.Locked then
      classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\Images\\locked");
    else
      classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\Images\\unlocked");
    end
    r = .25;
    g = .25;
    b = 1;
    getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode):SetBackdropBorderColor(r, g, b);
    bar:SetStatusBarColor(r, g, b, .75);
    bar:SetValue(100);
    bg:SetStatusBarColor(r, g, b, 0.1);
    button:SetTextColor (.75, .75, 1);
    button:SetText(message);
    button.PS_ID = pos;
    button.PS_DATA = hsdata;
    button:GetParent():Show();
    button:Show();
    local w = button:GetTextWidth();
    if w > PS_width then
      PS_width = w;
    end
  end
  for target in string.gmatch(line, "[^\n]*") do
    local targetData = PSvars.Database[target];
    local unknown = false;
    if (string.len(target) == 0 or target == PS_UNKFIX) then
      PS_CSG = 0;
    else
      if targetData ~= nil then
        if (targetData.IsKOS and PS_dim == 0) then
          if (targetData.IsPlayer and targetData.IsEnemy) then
            DEFAULT_CHAT_FRAME:AddMessage(PS_HPF..target, .4, 1, .2);
            if PSvars.SentrySound then
              PlaySoundFile("Interface\\AddOns\\Personal Sentry\\sounds\\hitalert.wav");
            end
          else
            targetData.IsKOS = false;
            PSvars.Database[target] = targetData;
          end
        end
      end
      if ((PS_addpop == 1 or PS_dim == 0) and PSvars.SentrySound and targetData ~= nil) then
        if (targetData.IsEnemy and PS_Enemy == 0) then
          PS_Enemy = 1;
          PlaySoundFile("Sound\\Interface\\TalentScreenOpen.wav");
        elseif targetData.IsEnemy then
          PS_Enemy = PS_Enemy + 1;
          if (GetTime() - PS_ClickTime > 1) then
            PlaySoundFile("Sound\\Interface\\MouseOverTarget.wav");
          end
        end
        PS_ClickTime = GetTime();
      end
      if ((not PS_bgmode and not IsActiveBattlefieldArena()) or PS_addpop == 0) then
        target = PS_Process_Trg(target);
      end
      local isenemy = nil;
      local isplayer = nil;
      if targetData == nil then
        targetData = PS_GetEmptyTargetEntry();
      else
        isenemy = targetData.IsEnemy;
        isplayer = targetData.IsPlayer;
      end
      local IsPet = false;
      if targetData ~= nil then
        local level = targetData.Level;
        if ((targetData.IsGuess or targetData.TooHigh) and level ~= 70) then
          level = level.."+";
        end
        pos = pos + 1;
        local button = getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button");
        local bar = getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar");
        local bg = getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBGBar");
        local classicon = getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon");
        local message = "";
        local health = 100;
        local r1, g1, b1;
        button:SetAttribute("target", target);
        if targetData.Level ~= 0 then
          if isplayer then
            if PS_CLASSES[targetData.Class] then
              classicon:SetTexCoord(unpack(PS_CLASSES[targetData.Class]));
            else
              classicon:SetTexCoord(0, .25, 0, .25);
            end
            classicon:SetTexture("Interface\\Glues\\CharacterCreate\\UI-CharacterCreate-Classes");
            if(targetData.Race == nil) then
              message = target.." ("..level.." "..targetData.Class..")";
            else
              message = target.." ("..level.." "..targetData.Race.." "..targetData.Class..")";
            end
            if isenemy then
              r = PSvars.EnemyPlayer.r;
              g = PSvars.EnemyPlayer.g;
              b = PSvars.EnemyPlayer.b;
              r1 = PSvars.EnemyPlayerT.r;
              g1 = PSvars.EnemyPlayerT.g;
              b1 = PSvars.EnemyPlayerT.b;
            else
              r = PSvars.FriendlyPlayer.r;
              g = PSvars.FriendlyPlayer.g;
              b = PSvars.FriendlyPlayer.b;
              r1 = PSvars.FriendlyPlayerT.r;
              g1 = PSvars.FriendlyPlayerT.g;
              b1 = PSvars.FriendlyPlayerT.b;
            end
          else
            if targetData.Notes == "PvP" then
              message = target.." ("..level.." NPC PvP)";
            else
              message = target.." ("..level.." NPC)";
            end
            if isenemy then
              r = PSvars.EnemyNPC.r;
              g = PSvars.EnemyNPC.g;
              b = PSvars.EnemyNPC.b;
              r1 = PSvars.EnemyNPCT.r;
              g1 = PSvars.EnemyNPCT.g;
              b1 = PSvars.EnemyNPCT.b;
              classicon:SetTexCoord(0, 1, 0, 1);
              classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\npc");
            else
              r = PSvars.FriendlyNPC.r;
              g = PSvars.FriendlyNPC.g;
              b = PSvars.FriendlyNPC.b;
              r1 = PSvars.FriendlyNPCT.r;
              g1 = PSvars.FriendlyNPCT.g;
              b1 = PSvars.FriendlyNPCT.b;
              classicon:SetTexCoord(0, 1, 0, 1);
              classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\npc");
            end
          end
          if targetData.IsPet ~= nil then
            if (targetData.IsPet == true or (targetData.IsPet ~= false and not PSvars.GrabPet)) then
              if targetData.Race ~= nil then
                message = target.." ("..level.." "..targetData.Race.." Pet)";
                IsPet = true;
              else
                message = target.." ("..level.." NPC Pet)";
                IsPet = true;
              end
              if isenemy then
                r = PSvars.EnemyNPC.r;
                g = PSvars.EnemyNPC.g;
                b = PSvars.EnemyNPC.b;
                r1 = PSvars.EnemyNPCT.r;
                g1 = PSvars.EnemyNPCT.g;
                b1 = PSvars.EnemyNPCT.b;
                classicon:SetTexCoord(0, 1, 0, 1);
                classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\pet_unit");
              else
                r = PSvars.FriendlyNPC.r;
                g = PSvars.FriendlyNPC.g;
                b = PSvars.FriendlyNPC.b;
                r1 = PSvars.FriendlyNPCT.r;
                g1 = PSvars.FriendlyNPCT.g;
                b1 = PSvars.FriendlyNPCT.b;
                classicon:SetTexCoord(0, 1, 0, 1);
                classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\pet_unit");
              end
            elseif targetData.IsPet ~= false then
              if targetData.Race ~= nil then
                message = target.." ("..level.." "..targetData.Race.." "..targetData.IsPet.."'s Pet)";
                IsPet = true;
                else
                message = target.." ("..level.." "..targetData.IsPet.."'s Pet)";
                IsPet = true;
              end
              if isenemy then
                r = PSvars.EnemyNPC.r;
                g = PSvars.EnemyNPC.g;
                b = PSvars.EnemyNPC.b;
                r1 = PSvars.EnemyNPCT.r;
                g1 = PSvars.EnemyNPCT.g;
                b1 = PSvars.EnemyNPCT.b;
                classicon:SetTexCoord(0, 1, 0, 1);
                classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\pet_unit");
              else
                r = PSvars.FriendlyNPC.r;
                g = PSvars.FriendlyNPC.g;
                b = PSvars.FriendlyNPC.b;
                r1 = PSvars.FriendlyNPCT.r;
                g1 = PSvars.FriendlyNPCT.g;
                b1 = PSvars.FriendlyNPCT.b;
                classicon:SetTexCoord(0, 1, 0, 1);
                classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\pet_unit");
              end
            end
          end
          if targetData.Notes ~= nil then
            if string.lower(targetData.Notes) == "elite" then
              message = target.." ("..level.." NPC Elite)";
              if isenemy then
                r = PSvars.EnemyNPC.r;
                g = PSvars.EnemyNPC.g;
                b = PSvars.EnemyNPC.b;
                r1 = PSvars.EnemyNPCT.r;
                g1 = PSvars.EnemyNPCT.g;
                b1 = PSvars.EnemyNPCT.b;
                classicon:SetTexCoord(0, 1, 0, 1);
                classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\1337");
              else
                r = PSvars.FriendlyNPC.r;
                g = PSvars.FriendlyNPC.g;
                b = PSvars.FriendlyNPC.b;
                r1 = PSvars.FriendlyNPCT.r;
                g1 = PSvars.FriendlyNPCT.g;
                b1 = PSvars.FriendlyNPCT.b;
                classicon:SetTexCoord(0, 1, 0, 1);
                classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\1337");
              end
            elseif targetData.Notes == "rare" or targetData.notes == "rareelite" then
              if targetData.Notes == "rare" then
                message = target.." ("..level.." NPC Rare)";
              else
                message = target.." ("..level.." NPC Rare-Elite)";
              end
              if isenemy then
                r = PSvars.EnemyNPC.r;
                g = PSvars.EnemyNPC.g;
                b = PSvars.EnemyNPC.b;
                r1 = PSvars.EnemyNPCT.r;
                g1 = PSvars.EnemyNPCT.g;
                b1 = PSvars.EnemyNPCT.b;
                classicon:SetTexCoord(0, 1, 0, 1);
                classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\rare");
              else
                r = PSvars.FriendlyNPC.r;
                g = PSvars.FriendlyNPC.g;
                b = PSvars.FriendlyNPC.b;
                r1 = PSvars.FriendlyNPCT.r;
                g1 = PSvars.FriendlyNPCT.g;
                b1 = PSvars.FriendlyNPCT.b;
                classicon:SetTexCoord(0, 1, 0, 1);
                classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\rare");
              end
            end
          end
        else
          unknown = true;
          classicon:SetTexCoord(0, 1, 0, 1);
          found = string.find(message, "%s");
          if found == nil then
            message = target..PS_UNK2;
            r = PSvars.UNKPlayer.r;
            g = PSvars.UNKPlayer.g;
            b = PSvars.UNKPlayer.b;
            r1 = PSvars.UNKPlayerT.r;
            g1 = PSvars.UNKPlayerT.g;
            b1 = PSvars.UNKPlayerT.b;
            classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\unk_pg");
          else
            message = target..PS_UNK2;
            r = PSvars.UNKNPC.r;
            g = PSvars.UNKNPC.g;
            b = PSvars.UNKNPC.b;
            r1 = PSvars.UNKNPCT.r;
            g1 = PSvars.UNKNPCT.g;
            b1 = PSvars.UNKNPCT.b;
            classicon:SetTexture("Interface\\AddOns\\Personal Sentry\\images\\unk_npc");
          end
        end
        getglobal("PS_PopupButton"..pos..PS_CombatMode..PS_Split..PSvars.PopupMode):SetBackdropBorderColor(r, g, b);
        local listData = PS_GetListData(target);
        if listData.pos < 2 then
          listData.pos = pos;
          if listData.time == 0 then
            listData.phase = .8;
            listData.time = GetTime();
            targetData.DayNum = date("%j");
            PSvars.Database[target] = targetData;
          end
          if listData.health == 0 then
            listData.health = 100;
          end
          health = listData.health;
          if not unknown then
            listData.known = true;
          end
        else
          listData.pos = pos;
          health = listData.health;
        end
        PSvars.list[target] = listData;
        bar:SetStatusBarColor(r, g, b, 1);
        bg:SetStatusBarColor(r, g, b, .1);
        if not unknown then
          if PSvars.CustomPopup ~= "" then
            message = PSvars.CustomPopup;
            if (string.lower(targetData.Notes) == "elite" or targetData.Notes == "rare" or targetData.notes == "rareelite" or (targetData.Notes == "PvP" and not targetData.IsPet)) then
              if string.lower(targetData.Notes) == "elite" then
                message = string.gsub(message, '%%c', "Elite");
              elseif targetData.Notes == "rare" then
                message = string.gsub(message, '%%c', "Rare");
              elseif targetData.Notes == "rareelite" then
                message = string.gsub(message, '%%c', "Rare-Elite");
              elseif not isplayer then
                message = string.gsub(message, '%%c', "PvP");
              end
            end
            if targetData.IsPet ~= nil then
              if (targetData.IsPet == true or (targetData.IsPet ~= false and not PSvars.GrabPet)) then
                message = string.gsub(message, '%%c', "Pet");
                IsPet = true;
              elseif targetData.IsPet ~= false then
                message = string.gsub(message, '%%c', targetData.IsPet.."'s Pet");
                IsPet = true;
              end
            end
            if string.find(message, '%%c') then
              if targetData.Race == nil then
                message = string.gsub(message, ' %%c', "");
                message = string.gsub(message, '%%c ', "");
                message = string.gsub(message, '%%c', "");
              else
                message = string.gsub(message, '%%c', targetData.Class);
              end
            end
            if targetData.Race == nil then
              message = string.gsub(message, '%%r', "NPC");
            else
              message = string.gsub(message, '%%r', targetData.Race);
            end
            message = string.gsub(message, '%%n', target);
            message = string.gsub(message, '%%l', level);
            if string.find(message, "nohealth") then
              health = 0;
              message = string.gsub(message, ' nohealth', "");
              message = string.gsub(message, 'nohealth ', "");
              message = string.gsub(message, 'nohealth', "");
            end
          end
          if (PSvars.ClassTextcolors and not IsPet) then
            if (targetData.Class ~= nil and targetData.Class ~= "" and targetData.Race ~= nil) then
              local colorData = popup_class_color[targetData.Class];
              r1 = colorData.r;
              g1 = colorData.g;
              b1 = colorData.b;
            end
          end
          if (PSvars.ClassBGcolors and not IsPet) then
            if (targetData.Class ~= nil and targetData.Class ~= "" and targetData.Race ~= nil) then
              local colorData = popup_class_color[targetData.Class];
              bar:SetStatusBarColor(colorData.r - .35, colorData.g - .35, colorData.b - .35, 1);
              bg:SetStatusBarColor(colorData.r - .35, colorData.g - .35, colorData.b - .35, .1);
            end
          end
        end
        if unknown then
          PSvars.Database[target] = nil;
        end
        button:SetTextColor (r1, g1, b1);
        bar:SetValue(health);
        button:SetText(message);
        button.PS_ID = pos;
        if PS_CSG == 0 then
          button.PS_X = PS_X;
          button.PS_Y = PS_Y;
        else
          button.PS_X = 999;
          button.PS_Y = 999;
          PS_CSG = 0;
        end
        button.PS_DATA = target;
        button:GetParent():Show();
        button:Show();
        local w = button:GetTextWidth();
        if w > PS_width then
          PS_width = w;
        end
      end
    end
    if pos >= PSvars.MaxTargets then
      break
    end;
  end
  if PS_dim == 1 then
    PS_dim = 0;
  end
  if pos > 1 then
    PS_tpos = pos;
    PS_neww = PS_width;
    if (PS_tpos > 21 and PS_Split == "" and PSvars.Split) then
      if PSvars.PopupMode == "DOWNWARD" then
        if PSvars.scale == .55 then
          PS_Ffix = 59;
        elseif PSvars.scale == .7 then
          PS_Ffix = 77;
        elseif PSvars.scale == .85 then
          PS_Ffix = 94;
        else
          PS_Ffix = 110;
        end
        PS_Frame:ClearAllPoints();
        PS_Frame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.DownL - PS_Ffix, PSvars.DownT);
      end
      PS_Clear_Popup();
      PS_addpop = 0;
      PS_dim = 1;
      PS_Split = "Split";
      PS_Process_Tooltip(PS_thelist);
      return;
    elseif (PS_tpos < 22 and PS_Split == "Split") or (PS_tpos > 21 and PS_Split == "Split" and not PSvars.Split) then
      PS_Clear_Popup();
      PS_addpop = 0;
      PS_dim = 1;
      PS_Split = "";
      PS_Process_Tooltip(PS_thelist);
      return;
    elseif (PSvars.PopupMode == "DOWNWARD" and PS_Split == "") then
      PS_Frame:ClearAllPoints();
      PS_Frame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.DownL, PSvars.DownT);
    elseif PSvars.PopupMode == "UPWARD" then
      local frame = getglobal("PS_Popup"..PS_CombatMode..PS_Split.."UPWARD");
      frame:ClearAllPoints();
      frame:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", PSvars.UpL, PSvars.UpT);
    end
    PS_Display_Popup(PS_width + 10);
  end
end

function PS_HealthUpdate(name)

  if (name == nil and UnitName("target") == nil) then
    return;
  end
  if PSvars.CustomPopup ~= "" then
    if string.find(PSvars.CustomPopup, "nohealth") then
      return;
    end
  end
  local unitname = nil;
  local health = nil;
  local enemy = nil;
  local val = nil;
  if name == nil then
    unitname = UnitName("target");
    enemy = UnitIsEnemy("target", "player");
  else
    unitname = name;
    enemy = UnitIsEnemy("mouseover", "player");
  end
  local listData = PS_GetListData(unitname);
  if listData.pos < 2 then
    return;
  end
  local targetData = PS_GetUnitData(unitname);
  button = getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button");
  bar = getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar");
  if name == nil then
    health = UnitHealth("target");
  else
    health = UnitHealth("mouseover");
  end
  if not enemy then
    if name == nil then
      val = UnitHealthMax("target");
    else
      val = UnitHealthMax("mouseover");
    end
    health = health / val * 100;
  end
  if (health == 0 and not PSvars.DeathDetect) then
    health = 100;
  end
  listData.health = health;
  PSvars.list[unitname] = listData;
  bar:SetValue(health);
  button:GetParent():Show();
  button:Show();
  if name == nil then
    if (UnitIsDeadOrGhost("target") and PSvars.DeathDetect) then
      PS_DeathDetect(unitname);
    end
  else
    if (UnitIsDeadOrGhost("mouseover") and PSvars.DeathDetect) then
      PS_DeathDetect(unitname);
    end
  end
end

function PS_Process_Trg(trg)

  if not PSvars.tracker then
    return trg;
  end
  local counter = 0;
  for name in string.gmatch(trg, "|c%x%x%x%x%x%x%x%x([^|]+)|r") do
    trg = name;
    if counter == 0 then
      return name;
    end
  end
  return trg;
end

function PS_Display_Popup(PS_width)

  local cnt = 0;
  if PSvars.PopupMode == "DOWNWARD" then
    PS_Frame:Show();
  end
  getglobal("PS_Popup"..PS_CombatMode..PS_Split..PSvars.PopupMode):SetWidth(PS_width + UNITPOPUP_BORDER_WIDTH);
  getglobal("PS_Popup"..PS_CombatMode..PS_Split..PSvars.PopupMode):SetHeight(PS_PopupButton1UPWARD:GetHeight() * PSvars.scale);
  getglobal("PS_Popup"..PS_CombatMode..PS_Split..PSvars.PopupMode):Show();
  for i=1, PS_tpos do
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode):SetWidth(PS_width + 36);
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button"):SetWidth(PS_width + 4);
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar"):SetWidth(PS_width + 6);
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBGBar"):SetWidth(PS_width + 6);
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode):SetScale(PSvars.scale);
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode):SetHeight(PS_PopupButton1UPWARD:GetHeight());
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode):Show();
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode):SetAlpha(1);
  end
  getglobal("PS_Popup"..PS_CombatMode..PS_Split..PSvars.PopupMode.."LockButton"):SetScale(PSvars.scale);
  for i=2, PS_tpos do
    getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode):SetScale(PSvars.scale * 1.25);
    getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode):SetHeight(PS_PopupButton1UPWARD:GetHeight());
    getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode):Show();
    getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode):SetAlpha(1);
  end
  for target in string.gmatch(PS_thelist, "[^\n]*") do
    if string.len(target) > 0 then
      listData = PS_GetListData(target);
      if listData.pos > 1 then
        cnt = cnt + 1;
        if cnt < PSvars.MaxTargets then
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar"):SetAlpha(listData.phase);
        end
      end
    end
  end
end

function PS_Clear_Popup()

  PS_neww = 0;
  for i=1, PS_tpos do
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button"):SetText("");
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode).PS_DATA = "";
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode).PS_X = 999;
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode).PS_Y = 999;
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode):SetAlpha(0);
    getglobal("PS_PopupButton"..i..PS_CombatMode..PS_Split..PSvars.PopupMode):Hide();
  end
  PS_Frame:Hide();
  getglobal("PS_Popup"..PS_CombatMode..PS_Split..PSvars.PopupMode):Hide();
  for i=2, PS_tpos do
    getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode.."Button"):SetText("");
    getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode):SetAlpha(0);
    getglobal("PS_PopupButton"..i..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode):Hide();
  end
  PS_tpos = 0;
end

function PS_KeepDamage(list)

  for target in string.gmatch(list, "[^\n]*") do
    if string.len(target) > 0 then
      listData = PS_GetListData(target);
      listData.pos = 0;
      PSvars.list[target] = listData;
    end
  end
end

function PS_MouseOverUpdate(elapsed)

  this.TimeSinceLastUpdate = this.TimeSinceLastUpdate + elapsed;
  PS_dimtimer();
  if (GameTooltip:IsOwned(Minimap) and PSvars.tracker and GameTooltipTextLeft1:GetText() ~= nil and PS_SentryCheck) then
    if GameTooltipTextLeft1:GetText() ~= PS_lasttip then
      local ttip = PS_Process_Trg(GameTooltipTextLeft1:GetText());
      GameTooltipTextLeft1:SetText(PS_PreParseNames(ttip));
      GameTooltip:Show();
      if ((IsShiftKeyDown() or ((PS_bgmode or IsActiveBattlefieldArena()) and PSvars.BGMode == "BG") or (not PS_bgmode and not IsActiveBattlefieldArena() and PSvars.BGMode == "NOBG") or PSvars.BGMode == true) and GetTime() - PS_starttime > PS_mocheck) then
        local x, y = GetCursorPosition();
        x = x / Minimap:GetEffectiveScale();
        y = y / Minimap:GetEffectiveScale();
        local cx, cy = Minimap:GetCenter();
        if CURSOR_OFFSET_X ~= nil then
          PS_X = x + CURSOR_OFFSET_X - cx;
        else
          PS_X = x - cx;
        end
        if CURSOR_OFFSET_Y ~= nil then
          PS_Y = y + CURSOR_OFFSET_Y - cy;
        else
          PS_Y = y - cy;
        end
        PS_MOCE2();
      end
      PS_lasttip = GameTooltipTextLeft1:GetText();
    end
  elseif (GameTooltipTextLeft1:GetText() ~= PS_lasttip and GameTooltip:IsOwned(TargetFrame)) then
    if not UnitIsPlayer("mouseover") then
      local listData = PS_GetListData(UnitName("mouseover"));
      if listData.pos > 1 then
        PS_GrabPet(UnitName("mouseover"), UnitIsEnemy("mouseover", "player"), "mouseover");
        PS_CaptureAttack(UnitName("mouseover"), "YOU", nil, "mouseover", 1);
        PS_Refresh(UnitName("mouseover"), UnitIsPlayer("mouseover"), UnitIsEnemy("mouseover", "player"), "mouseover", UnitLevel("mouseover"), PS_UnitRace("mouseover"), PS_UnitClass("mouseover"), listData.pos);
      end
    end
    PS_lasttip = GameTooltipTextLeft1:GetText();
  elseif (PS_cchck ~= nil and PS_sendmsg ~= "") then
    if (((PS_stealth and PS_lastpinged ~= PS_cchck) or PS_skipchk == 1) or PS_lastpinged ~= PS_cchck) then
      PS_Notification();
    end
    PS_sendmsg = "";
    PS_cchck = nil;
    PS_skipchk = 0;
  elseif PS_remove == 3 then
    if (PS_cchck2 ~= UnitName("target")) then
      PS_RemoveTarget(PS_cchck2);
    else
      PS_remove = 0;
    end
  elseif this.TimeSinceLastUpdate > .5 then
    if PS_DeathTime ~= nil then
      if GetTime() - PS_DeathTime > .5 then
        for target in string.gmatch(PS_DeathName, "[^\n]*") do
          if string.len(target) > 0 then
            PS_DeathDetect2(target);
          end
        end
      end
    end
    this.TimeSinceLastUpdate = 0;
  end
end

function PS_dimtimer()

  if GetTime() - PS_timer < 1 then
    return;
  end
  PS_TFF = 0;
  PS_Redraw = false;
  PS_HealthUpdate(nil);
  PS_timer = GetTime();
  local frame;
  for target in string.gmatch(PS_thelist, "[^\n]*") do
    if string.len(target) > 0 then
      local listData = PS_GetListData(target);
      local targetData = PS_GetUnitData(target);
      local tmp = 0;
      local name = nil;
      if listData.pos > 1 then
        if (UnitName("target") == target or UnitName("mouseover") == target) then
          listData.phase = 1;
          listData.time = GetTime();
          targetData.DayNum = date("%j");
          PSvars.Database[target] = targetData;
          PSvars.list[target] = listData;
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar"):SetAlpha(1);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button"):SetAlpha(1);
          frame = getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon");
          UIFrameFlash(frame, .2, .2, .8, true, 0, 0);
          if UnitName("mouseover") == target then
            name = target;
          end
          PS_HealthUpdate(name);
        elseif listData.phase == 1 then
          listData.phase = .8;
          PSvars.list[target] = listData;
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar"):SetAlpha(.8);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button"):SetAlpha(.9);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon"):SetAlpha(.9);
        end
        if listData.Heal then
          if (GetTime() - listData.Heal > PSvars.HealTime) then
            listData.Heal = false;
            listData.heals = 0;
          end
        end
        if listData.Healed then
          if (GetTime() - listData.Healed > (PSvars.HealTime/2)) then
            listData.Healed = false;
          end
        end
        local Healer = false;
        local Healed = false;
        if (PSvars.Healer and listData.Heal) then
          Healer = true;
        end
        if (PSvars.Healer and listData.Healed) then
          Healed = true;
        end
        if ((tonumber(listData.damage) > 0 and PSvars.Damage) or Healer or Healed or targetData.IsKOS) then
          local button = getglobal("PS_PopupButton"..listData.pos..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode.."Button");
          frame = getglobal("PS_PopupButton"..listData.pos..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode);
          button.id = listData.pos;
          if (targetData.IsKOS and tonumber(listData.damage) == 0 and not Healer and not (Healed and tonumber(listData.damage) == 0)) then
            button:SetText(PS_HITLIST);
            UIFrameFlash(frame, .4, .4, .8, false, 0, 0);
          elseif Healer then
            button:SetText(listData.heals);
          elseif (Healed and tonumber(listData.damage) == 0) then
            button:SetText("Healed");
          elseif PSvars.Damage then
            button:SetText(listData.damage);
          end
          if targetData.IsKOS then
            if Healer then
              button:SetTextColor (.1, 1, .1);
              button:SetText(listData.heals);
            elseif Healed then
              button:SetTextColor (0, .9, .9);
            else
              button:SetTextColor (1, .1, .1);
            end
          elseif Healer then
            button:SetTextColor (.1, 1, .1);
          elseif Healed then
            button:SetTextColor (0, .9, .9);
          else
            button:SetTextColor (.8, .8, .8);
          end
          button:GetParent():Show();
          button:Show();
        else
          local button = getglobal("PS_PopupButton"..listData.pos..PS_CombatMode.."Dam"..PS_Split..PSvars.PopupMode.."Button");
          button:SetText("");
          button:GetParent():Show();
          button:Show();
        end
        if PSvars.SetTime == 9999 then
          listData.phase = .8;
          PSvars.list[target] = listData;
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar"):SetAlpha(.8);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button"):SetAlpha(.9);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon"):SetAlpha(.9);
        elseif GetTime() - listData.time > PSvars.SetTime then
          PS_remove = 1;
          PS_RemoveTarget(target);
        elseif (GetTime() - listData.time > (PSvars.SetTime/1.5)) then
          listData.phase = .2;
          listData.health = 100;
          PSvars.list[target] = listData;
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar"):SetAlpha(listData.phase);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button"):SetAlpha(.7);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon"):SetAlpha(.7);
        elseif (GetTime() - listData.time > (PSvars.SetTime/3)) then
          listData.phase = .5;
          PSvars.list[target] = listData;
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonBar"):SetAlpha(listData.phase);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."Button"):SetAlpha(.8);
          getglobal("PS_PopupButton"..listData.pos..PS_CombatMode..PS_Split..PSvars.PopupMode.."ButtonClassIcon"):SetAlpha(.8);
        end
      end
    end
  end
end

function PS_GrabPet(name, isenemy, type)

  local IsPet = false;
  local grabpet = nil;
  local targetData = PS_GetUnitData(name);
  local IsPVP = true;
  local iselite = UnitClassification(type);
  if targetData.IsPlayer then
    return;
  end
  if type ~= nil then
    IsPVP = UnitIsPVP(type);
  end
  if (type == "mouseover" and GameTooltipTextLeft1:GetText() ~= nil) then
    if GameTooltip:NumLines() > 1 then
      grabpet = GameTooltipTextLeft2:GetText();
      if (string.find(grabpet, PS_PET) or string.find(grabpet, PS_MINION) or string.find(grabpet, PS_GUARDIAN) or string.find(grabpet, PS_SERVANT)) then
        grabpet = string.gsub(grabpet, PS_MINION, "");
        grabpet = string.gsub(grabpet, PS_PET, "");
        grabpet = string.gsub(grabpet, PS_GUARDIAN, "");
        grabpet = string.gsub(grabpet, PS_SERVANT, "");
        if grabpet ~= nil then
          if (string.find(grabpet, PS_TOTEM) or grabpet == UnitName("player")) then
            return;
          end
          targetData.IsPet = grabpet;
          if name ~= PS_SHADOWFIEND then
            targetData.Race = UnitCreatureType(type);
          else
            targetData.Race = "Illusionary";
          end
          targetData.IsEnemy = isenemy;
          IsPet = true;
        elseif targetData.IsPet == true then
          targetData.IsPet = false;
        end
      elseif targetData.IsPet == true then
        targetData.IsPet = false;
      end
    elseif targetData.IsPet == true then
      targetData.IsPet = false;
    end
    PSvars.Database[name] = targetData;
  elseif ((type == "target" and (IsPVP or IsPet) and (UnitCreatureType(type) == PS_BEAST or UnitCreatureType(type) == PS_ELEMENTAL or UnitCreatureType(type) == PS_DEMON))) then
    if (targetData.IsPet == nil or targetData.IsPet == false) then
      targetData.IsPet = true;
    end
    if (IsPVP and targetData.Notes == "") then
      targetData.Notes = "PvP";
    end
    targetData.Race = UnitCreatureType(type);
    targetData.IsEnemy = isenemy;
    PSvars.Database[name] = targetData;
  end
  if IsPet then
    local ownerData = PSvars.Database[grabpet];
    local level = nil;
    if ownerData ~= nil then
      if not ownerData.IsPlayer then
        return;
      end
      if IsPVP then
        targetData.Notes = "PvP";
        ownerData.Notes = "PvP";
      elseif targetData.Notes ~= "PvP2" then
        targetData.Notes = "";
      end
      if ownerData.Notes == "PvP2" then
        targetData.Notes = "PvP2";
        PSvars.Database[name] = targetData;
      end
      if iselite == "elite" or iselite == "rare" or iselite == "rareelite" then
        targetData.Notes = iselite;
      else
        iselite = false;
      end
      level = ownerData.Level;
      if UnitLevel(type) ~= -1 then
        level = UnitLevel(type);
      else
        level = PS_MyLevel + 10;
        ownerData.TooHigh = PS_MyLevel;
      end
      ownerData.IsEnemy = isenemy;
    else
      if UnitLevel(type) ~= -1 then
        level = UnitLevel(type);
      else
        level = PS_MyLevel + 10;
      end
      ownerData = PS_GetEmptyTargetEntry();
      ownerData.IsEnemy = isenemy;
      ownerData.IsGuess = true;
      ownerData.Race = "Unknown";
      ownerData.IsPlayer = true;
      if IsPVP then
        ownerData.Notes = "PvP";
      else
        ownerData.Notes = "";
      end
      if targetData.Race ~= nil then
        if targetData.Race == PS_BEAST then
          ownerData.Class = PS_HUNTER;
        elseif targetData.Race == PS_ELEMENTAL then
          if name ~= "Treant" then
            ownerData.Class = PS_MAGE;
          else
            ownerData.Class = PS_DRUID;
          end
        elseif name == PS_SHADOWFIEND then
          ownerData.Class = PS_PRIEST;
        elseif targetData.Race == PS_DEMON then
          ownerData.Class = PS_WARLOCK;
        else
          ownerData.IsPlayer = false;
          ownerData.IsGuess = false;
          ownerData.Race = nil;
          ownerData.Class = PS_WARRIOR;
        end
      else
        ownerData.IsGuess = false;
        ownerData.IsPlayer = false;
        ownerData.Class = PS_WARRIOR;
      end
    end
    if string.find(grabpet, " ") then
      ownerData.IsGuess = false;
      ownerData.IsPlayer = false;
      ownerData.Race = nil;
      ownerData.Class = PS_WARRIOR;
    end
    PSvars.Database[grabpet] = ownerData;
    local listData = PSvars.list[grabpet];
    if listData ~= nil then
      if (listData.pos > 1 and ownerData.IsPlayer and ownerData.IsGuess and IsPVP) then
        PS_Refresh(grabpet, ownerData.IsPlayer, isenemy, "Nil", level, ownerData.Race, ownerData.Class, listData.pos);
      else
        if ownerData.Level < level then
          ownerData.Level = level;
          PSvars.Database[grabpet] = ownerData;
        end
        if (not ownerData.IsPlayer or (ownerData.IsPlayer and (ownerData.Hide or (PSvars.MO == "ALL" and ownerData.Notes == "") or (PSvars.MO == "ENEMY PLAYERS" and (not isenemy or ownerData.Notes == "")) or (PSvars.MO == "ALL PLAYERS" and ownerData.Notes == "") or (PSvars.MO == "ENEMIES" and (not isenemy or (isenemy and ownerData.Notes == ""))) or (PSvars.MO == "FLAGGED AND ELITE ENEMIES" and (not isenemy or ownerData.Notes == "" and not iselite))))) then
          return;
        else
          PS_CaptureAttack(grabpet);
        end
      end
    else
      if ownerData.Level < level then
        ownerData.Level = level;
        PSvars.Database[grabpet] = ownerData;
      end
      if (not ownerData.IsPlayer or (ownerData.IsPlayer and (not IsPVP or ownerData.Hide or (PSvars.MO == "ALL" and ownerData.Notes == "") or (PSvars.MO == "ENEMY PLAYERS" and (not isenemy or ownerData.Notes == "")) or (PSvars.MO == "ALL PLAYERS" and ownerData.Notes == "") or (PSvars.MO == "ENEMIES" and (not isenemy or (isenemy and ownerData.Notes == ""))) or (PSvars.MO == "FLAGGED AND ELITE ENEMIES" and (not isenemy or ownerData.Notes == "" and not iselite))))) then
        return;
      else
        PS_CaptureAttack(grabpet, nil, nil, nil, 3);
      end
    end
  end
end

function PS_GetEmptyTargetEntry()

  return {
    Level = 0,
    Class = "",
    Race = "",
    Zone = "",
    SubZone = "",
    Notes = "",
    IsKOS = false,
    IsTemp = false,
    IsPet = false
    }
end

function PS_GetEmptyListEntry()

  return {
    pos = 0,
    time = 0,
    phase = 0,
    health = 0,
    damage = 0,
    heals = 0,
    known = false
    }
end

function PS_GetEmptyCompareEntry()

  return {
    listed = 0
    }
end

function PS_GetListData(name)

  data = PSvars.list[name];
  if data ~= nil then
    return data;
  end
  return PS_GetEmptyListEntry();
end

function PS_GetCompareData(name)

  data = PSvars.compare[name];
  if data ~= nil then
    return data;
  end
  return PS_GetEmptyCompareEntry();
end

function PS_GetUnitData(name)

  data = PSvars.Database[name];
  if data ~= nil then
    return data;
  end
  return PS_GetEmptyTargetEntry();
end

function PS_DebugEcho(text)

  if PS_debugmode then
    DEFAULT_CHAT_FRAME:AddMessage("#PS DEBUG: "..text, 1, 1, 1);
  end
end

function PS_UnitClass(target)
  local tempclass;
  tempclass = UnitClass(target);
  tempclass = PS_UnitClassFix(tempclass);
  return tempclass;
end

function PS_UnitClassFix(tempclass)
  if tempclass == nil then
    return nil;
  end
  if tempclass == PS_WARRIOR_F then
    return PS_WARRIOR;
  elseif tempclass == PS_MAGE_F then
    return PS_MAGE;
  elseif tempclass == PS_ROGUE_F then
    return PS_ROGUE;
  elseif tempclass == PS_HUNTER_F then
    return PS_HUNTER;
  elseif tempclass == PS_SHAMAN_F then
    return PS_SHAMAN;
  elseif tempclass == PS_PRIEST_F then
    return PS_PRIEST;
  elseif tempclass == PS_WARLOCK_F then
    return PS_WARLOCK;
  elseif tempclass == PS_PALADIN_F then
    return PS_PALADIN;
  elseif tempclass == PS_DRUID_F then
    return PS_DRUID;
  end
  return tempclass;
end

function PS_UnitRace(target)
  local temprace;
  temprace = UnitRace(target);
  temprace = PS_UnitRaceFix(temprace);
  return temprace;
end

function PS_UnitRaceFix(temprace)
  if temprace == nil then
    return nil;
  end
  if temprace == PS_DWARF_F then
    return PS_DWARF;
  elseif temprace == PS_NIGHTELF_F then
    return PS_NIGHTELF;
  elseif temprace == PS_HUMAN_F then
    return PS_HUMAN;
  elseif temprace == PS_DRAENEI_F then
    return PS_DRAENEI;
  elseif temprace == PS_GNOME_F then
    return PS_GNOME;
  elseif temprace == PS_UNDEAD_F then
    return PS_UNDEAD;
  elseif temprace == PS_BLOODELF_F then
    return PS_BLOODELF;
  elseif temprace == PS_TAUREN_F then
    return PS_TAUREN;
  elseif temprace == PS_ORC_F then
    return PS_ORC;
  elseif temprace == PS_TROLL_F then
    return PS_TROLL;
  end
  return temprace;
end
